/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.util;

import com.nike.riposte.server.http.RequestInfo;
import com.nike.riposte.util.AntPathMatcher;
import com.nike.riposte.util.Matcher;
import com.nike.riposte.util.MatcherUtil;
import io.netty.handler.codec.http.HttpMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MultiMatcher
implements Matcher {
    protected static final AntPathMatcher pathParamExtractor = new AntPathMatcher();
    @NotNull
    protected final Collection<String> matchingPathTemplates;
    @NotNull
    protected final Collection<HttpMethod> matchingMethods;
    protected final boolean matchAllMethods;

    protected MultiMatcher(@NotNull Collection<String> matchingPathTemplates, @NotNull Collection<HttpMethod> matchingMethods, boolean matchAllMethods) {
        if (matchingPathTemplates == null || matchingPathTemplates.isEmpty() || matchingPathTemplates.stream().anyMatch(path -> !path.startsWith("/"))) {
            throw new IllegalArgumentException("matchingPathTemplates cannot be null or empty and paths must start with a forward slash '/'");
        }
        if (matchingMethods == null) {
            throw new IllegalArgumentException("matchingMethods cannot be null");
        }
        this.matchingMethods = matchingMethods;
        this.matchingPathTemplates = matchingPathTemplates.stream().map(MatcherUtil::stripEndSlash).collect(Collectors.toList());
        this.matchAllMethods = matchAllMethods;
    }

    @NotNull
    public static MultiMatcher match(@NotNull Collection<String> matchingPathTemplates) {
        return new MultiMatcher(matchingPathTemplates, Collections.emptyList(), true);
    }

    @NotNull
    public static MultiMatcher match(@NotNull Collection<String> matchingPathTemplates, HttpMethod ... matchingMethods) {
        if (matchingMethods == null || matchingMethods.length == 0) {
            throw new IllegalArgumentException("matchingMethods cannot be null or empty. If you want to match all methods use the single-arg match(Collection<String>) method.");
        }
        return new MultiMatcher(matchingPathTemplates, Arrays.asList(matchingMethods), false);
    }

    @NotNull
    public static MultiMatcher match(@NotNull Collection<String> matchingPathTemplates, @NotNull Collection<HttpMethod> matchingMethods) {
        if (matchingMethods == null || matchingMethods.isEmpty()) {
            throw new IllegalArgumentException("matchingMethods cannot be null or empty. If you want to match all methods use the single-arg match(Collection<String>) method.");
        }
        return new MultiMatcher(matchingPathTemplates, matchingMethods, false);
    }

    @Override
    @NotNull
    public Collection<HttpMethod> matchingMethods() {
        return this.matchingMethods;
    }

    @Override
    @NotNull
    public Collection<String> matchingPathTemplates() {
        return this.matchingPathTemplates;
    }

    @Override
    @NotNull
    public Optional<String> matchesPath(@NotNull RequestInfo<?> request) {
        if (request == null || request.getPath() == null) {
            return Optional.empty();
        }
        String path = MatcherUtil.stripEndSlash(request.getPath());
        return this.matchingPathTemplates.stream().filter(pathTemplate -> pathParamExtractor.match((String)pathTemplate, path)).findFirst();
    }

    @Override
    public boolean matchesMethod(@NotNull RequestInfo<?> request) {
        if (this.matchAllMethods) {
            return true;
        }
        if (request == null || request.getMethod() == null) {
            return false;
        }
        return this.matchingMethods().contains(request.getMethod());
    }

    @Override
    public boolean isMatchAllMethods() {
        return this.matchAllMethods;
    }
}

