/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.util;

import com.nike.riposte.server.http.RequestInfo;
import com.nike.riposte.util.AntPathMatcher;
import com.nike.riposte.util.Matcher;
import com.nike.riposte.util.MatcherUtil;
import io.netty.handler.codec.http.HttpMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class SingleMatcher
implements Matcher {
    protected static final AntPathMatcher pathParamExtractor = new AntPathMatcher();
    @NotNull
    protected final Collection<HttpMethod> matchingMethods;
    @NotNull
    protected final String matchingPathTemplate;
    protected final boolean matchAllMethods;
    @NotNull
    protected final Collection<String> matchingPathTemplates;
    @NotNull
    protected final Optional<String> cachedMatchesPathResponse;

    public SingleMatcher(@NotNull String matchingPathTemplate, @NotNull Collection<HttpMethod> matchingMethods, boolean matchAllMethods) {
        if (matchingPathTemplate == null || !matchingPathTemplate.startsWith("/")) {
            throw new IllegalArgumentException("matchingPathTemplate cannot be null and must start with a forward slash '/'");
        }
        if (matchingMethods == null) {
            throw new IllegalArgumentException("matchingMethods cannot be null");
        }
        matchingPathTemplate = MatcherUtil.stripEndSlash(matchingPathTemplate);
        this.matchingMethods = matchingMethods;
        this.matchingPathTemplate = matchingPathTemplate;
        this.matchingPathTemplates = Collections.singletonList(matchingPathTemplate);
        this.matchAllMethods = matchAllMethods;
        this.cachedMatchesPathResponse = Optional.of(matchingPathTemplate);
    }

    @NotNull
    public static SingleMatcher match(@NotNull String matchingPathTemplate) {
        return new SingleMatcher(matchingPathTemplate, Collections.emptyList(), true);
    }

    @NotNull
    public static SingleMatcher match(@NotNull String matchingPathTemplate, HttpMethod ... matchingMethods) {
        if (matchingMethods == null || matchingMethods.length == 0) {
            throw new IllegalArgumentException("matchingMethods cannot be null or empty. If you want to match all methods use the single-arg match(String) method.");
        }
        return new SingleMatcher(matchingPathTemplate, Arrays.asList(matchingMethods), false);
    }

    @NotNull
    public static SingleMatcher match(@NotNull String matchingPathTemplate, @NotNull Collection<HttpMethod> matchingMethods) {
        if (matchingMethods == null || matchingMethods.isEmpty()) {
            throw new IllegalArgumentException("matchingMethods cannot be null or empty. If you want to match all methods use the single-arg match(String) method.");
        }
        return new SingleMatcher(matchingPathTemplate, matchingMethods, false);
    }

    @Override
    @NotNull
    public Collection<HttpMethod> matchingMethods() {
        return this.matchingMethods;
    }

    @Override
    @NotNull
    public Collection<String> matchingPathTemplates() {
        return this.matchingPathTemplates;
    }

    @Override
    public boolean isMatchAllMethods() {
        return this.matchAllMethods;
    }

    @Override
    @NotNull
    public Optional<String> matchesPath(@NotNull RequestInfo<?> request) {
        if (request == null || request.getPath() == null) {
            return Optional.empty();
        }
        String path = MatcherUtil.stripEndSlash(request.getPath());
        if (pathParamExtractor.match(this.matchingPathTemplate, path)) {
            return this.cachedMatchesPathResponse;
        }
        return Optional.empty();
    }

    @Override
    public boolean matchesMethod(@NotNull RequestInfo<?> request) {
        if (this.matchAllMethods) {
            return true;
        }
        if (request == null || request.getMethod() == null) {
            return false;
        }
        return this.matchingMethods().contains(request.getMethod());
    }
}

