/*
 * Decompiled with CFR 0.152.
 */
package com.nike.riposte.util.text.parsercombinator;

import com.nike.internal.util.ImmutablePair;
import com.nike.internal.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public interface Parser<T> {
    public static final Object UNIT = new Object();

    public T parse(ParserInput var1) throws ParserFailure;

    default public T parse(CharSequence text) throws ParserFailure {
        return this.parse(new ParserInput(text, 0));
    }

    default public Optional<T> tryParse(ParserInput parserInput) {
        int offset = parserInput.getOffset();
        try {
            return Optional.of(this.parse(parserInput));
        }
        catch (ParserFailure failure) {
            parserInput.setOffset(offset);
            return Optional.empty();
        }
    }

    default public Optional<T> tryParse(CharSequence text) {
        return this.tryParse(new ParserInput(text, 0));
    }

    default public <R> Parser<Pair<T, R>> thenParse(Parser<R> parser) {
        return parserInput -> ImmutablePair.of(this.parse(parserInput), parser.parse(parserInput));
    }

    default public <R> Parser<Pair<T, R>> thenParse(Supplier<Parser<R>> supplier) {
        return parserInput -> this.thenParse((Parser)supplier.get()).parse(parserInput);
    }

    default public Parser<T> thenSkip(Parser<?> parser) {
        return parserInput -> {
            T result = this.parse(parserInput);
            parser.parse(parserInput);
            return result;
        };
    }

    default public Parser<T> thenSkip(Supplier<Parser<?>> supplier) {
        return parserInput -> this.thenSkip((Parser)supplier.get()).parse(parserInput);
    }

    default public Parser<T> or(Parser<T> parser) {
        return parserInput -> {
            int offset = parserInput.getOffset();
            try {
                return this.parse(parserInput);
            }
            catch (ParserFailure failure) {
                parserInput.setOffset(offset);
                return parser.parse(parserInput);
            }
        };
    }

    default public Parser<T> or(Supplier<Parser<T>> supplier) {
        return parserInput -> this.or((Parser)supplier.get()).parse(parserInput);
    }

    default public Parser<Optional<T>> optional() {
        return parserInput -> {
            try {
                return Optional.of(this.parse(parserInput));
            }
            catch (ParserFailure failure) {
                return Optional.empty();
            }
        };
    }

    default public Parser<List<T>> zeroOrMore() {
        return parserInput -> Parsers.zeroOrMore(this).parse(parserInput);
    }

    default public Parser<List<T>> zeroOrMore(Parser<?> separator) {
        return parserInput -> Parsers.zeroOrMore(this, separator).parse(parserInput);
    }

    default public Parser<List<T>> oneOrMore() {
        return parserInput -> Parsers.oneOrMore(this).parse(parserInput);
    }

    default public Parser<List<T>> oneOrMore(Parser<?> separator) {
        return parserInput -> Parsers.oneOrMore(this, separator).parse(parserInput);
    }

    default public Parser<T> filter(Predicate<T> predicate) {
        return parserInput -> Parsers.filter(this, predicate).parse(parserInput);
    }

    default public <R> Parser<R> map(Function<T, R> function) {
        return parserInput -> function.apply(this.parse(parserInput));
    }

    default public <R> Parser<R> flatMap(Function<T, Parser<R>> function) {
        return parserInput -> ((Parser)function.apply(this.parse(parserInput))).parse(parserInput);
    }

    public static class ParserInput {
        protected CharSequence text;
        protected int offset;

        public ParserInput(CharSequence text, int offset) {
            this.text = text;
            this.offset = offset;
        }

        public CharSequence getText() {
            return this.text;
        }

        public void setText(CharSequence text) {
            this.text = text;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParserInput that = (ParserInput)o;
            return Objects.equals(this.offset, that.offset) && Objects.equals(this.text, that.text);
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.text);
        }
    }

    public static class ParserFailure
    extends Exception {
        public ParserFailure() {
        }

        public ParserFailure(String message) {
            super(message);
        }

        public ParserFailure(ParserInput parserInput) {
            super(ParserFailure.formatParserInput(parserInput, Optional.empty()));
        }

        public ParserFailure(String cause, ParserInput parserInput) {
            super(ParserFailure.formatParserInput(parserInput, Optional.of(cause)));
        }

        private static String formatParserInput(ParserInput parserInput, Optional<String> cause) {
            CharSequence text = parserInput.getText();
            int offset = parserInput.getOffset();
            int length = text.length() > offset + 20 ? offset + 20 : text.length();
            StringBuilder s = new StringBuilder("Failed on input at '");
            if (text.length() > offset + 20) {
                s.append(text.subSequence(offset, offset + 20));
                s.append("...'");
            } else {
                s.append(text.subSequence(offset, text.length()));
                s.append("'");
            }
            if (cause.isPresent()) {
                s.append(" cause: ");
                s.append(cause.get());
            }
            return s.toString();
        }
    }

    public static class FloatParser
    implements Parser<Float> {
        private static final Pattern pattern = Pattern.compile("([-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)");
        public static final Parser<Float> singleton = new FloatParser();

        private FloatParser() {
        }

        @Override
        public Float parse(ParserInput parserInput) throws ParserFailure {
            Matcher matcher = pattern.matcher(parserInput.getText().subSequence(parserInput.getOffset(), parserInput.getText().length()));
            if (matcher.lookingAt()) {
                parserInput.setOffset(parserInput.getOffset() + matcher.end());
                String regexResult = matcher.toMatchResult().group(1);
                try {
                    return Float.valueOf(Float.parseFloat(regexResult));
                }
                catch (NullPointerException e) {
                    throw new ParserFailure("Float parser parsed null float value from input.");
                }
                catch (NumberFormatException e) {
                    throw new ParserFailure("Float parser parsed invalid float value from input text of '" + regexResult + "'.");
                }
            }
            throw new ParserFailure("Float parser using regex pattern '" + pattern.pattern() + "' did not match the input text ( using matcher.lookingAt() )", parserInput);
        }
    }

    public static class RegexParser
    implements Parser<MatchResult> {
        private final Pattern pattern;

        public RegexParser(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public MatchResult parse(ParserInput parserInput) throws ParserFailure {
            Matcher matcher = this.pattern.matcher(parserInput.getText().subSequence(parserInput.getOffset(), parserInput.getText().length()));
            if (matcher.lookingAt()) {
                parserInput.setOffset(parserInput.getOffset() + matcher.end());
                return matcher.toMatchResult();
            }
            throw new ParserFailure("Regular Expression parser with pattern '" + this.pattern.pattern() + "' did not match the input text ( using matcher.lookingAt() )", parserInput);
        }
    }

    public static class SkipParser {
        private final Parser<?> parser;

        public SkipParser(Parser<?> parser) {
            this.parser = parser;
        }

        public SkipParser skip(Parser<?> that) {
            return new SkipParser(parserInput -> {
                this.parser.parse(parserInput);
                that.parse(parserInput);
                return UNIT;
            });
        }

        public <U> Parser<U> thenParse(Parser<U> that) {
            return parserInput -> {
                this.parser.parse(parserInput);
                return that.parse(parserInput);
            };
        }
    }

    public static final class Apply {
        public static <A, R> Function<A, R> match(Function<A, R> function) {
            return function;
        }

        public static <A, B, R> Function<Pair<A, B>, R> match(BiFunction<A, B, R> function) {
            return pair -> function.apply(pair.getLeft(), pair.getRight());
        }

        public static <A, B, C, R> Function<Pair<Pair<A, B>, C>, R> match(Function3<A, B, C, R> function) {
            return pair -> function.apply(((Pair)pair.getLeft()).getLeft(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        public static <A, B, C, D, R> Function<Pair<Pair<Pair<A, B>, C>, D>, R> match(Function4<A, B, C, D, R> function) {
            return pair -> function.apply(((Pair)((Pair)pair.getLeft()).getLeft()).getLeft(), ((Pair)((Pair)pair.getLeft()).getLeft()).getRight(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        public static <A, B, C, D, E, R> Function<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, R> match(Function5<A, B, C, D, E, R> function) {
            return pair -> function.apply(((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft(), ((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)pair.getLeft()).getLeft()).getRight(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        public static <A, B, C, D, E, F, R> Function<Pair<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, F>, R> match(Function6<A, B, C, D, E, F, R> function) {
            return pair -> function.apply(((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft(), ((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)pair.getLeft()).getLeft()).getRight(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        public static <A, B, C, D, E, F, G, R> Function<Pair<Pair<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, F>, G>, R> match(Function7<A, B, C, D, E, F, G, R> function) {
            return pair -> function.apply(((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft(), ((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)pair.getLeft()).getLeft()).getRight(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        public static <A, B, C, D, E, F, G, H, R> Function<Pair<Pair<Pair<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, F>, G>, H>, R> match(Function8<A, B, C, D, E, F, G, H, R> function) {
            return pair -> function.apply(((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft(), ((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)pair.getLeft()).getLeft()).getRight(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        public static <A, B, C, D, E, F, G, H, I, R> Function<Pair<Pair<Pair<Pair<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, F>, G>, H>, I>, R> match(Function9<A, B, C, D, E, F, G, H, I, R> function) {
            return pair -> function.apply(((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft(), ((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)pair.getLeft()).getLeft()).getRight(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        public static <A> Predicate<A> test(Function<A, Boolean> function) {
            return function::apply;
        }

        public static <A, B> Predicate<Pair<A, B>> test(BiFunction<A, B, Boolean> function) {
            return pair -> (Boolean)function.apply(pair.getLeft(), pair.getRight());
        }

        public static <A, B, C> Predicate<Pair<Pair<A, B>, C>> test(Function3<A, B, C, Boolean> function) {
            return pair -> (Boolean)function.apply(((Pair)pair.getLeft()).getLeft(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        public static <A, B, C, D> Predicate<Pair<Pair<Pair<A, B>, C>, D>> test(Function4<A, B, C, D, Boolean> function) {
            return pair -> (Boolean)function.apply(((Pair)((Pair)pair.getLeft()).getLeft()).getLeft(), ((Pair)((Pair)pair.getLeft()).getLeft()).getRight(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        public static <A, B, C, D, E> Predicate<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>> test(Function5<A, B, C, D, E, Boolean> function) {
            return pair -> (Boolean)function.apply(((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft(), ((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)pair.getLeft()).getLeft()).getRight(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        public static <A, B, C, D, E, F> Predicate<Pair<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, F>> test(Function6<A, B, C, D, E, F, Boolean> function) {
            return pair -> (Boolean)function.apply(((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft(), ((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)pair.getLeft()).getLeft()).getRight(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        public static <A, B, C, D, E, F, G> Predicate<Pair<Pair<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, F>, G>> test(Function7<A, B, C, D, E, F, G, Boolean> function) {
            return pair -> (Boolean)function.apply(((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft(), ((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)pair.getLeft()).getLeft()).getRight(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        public static <A, B, C, D, E, F, G, H> Predicate<Pair<Pair<Pair<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, F>, G>, H>> test(Function8<A, B, C, D, E, F, G, H, Boolean> function) {
            return pair -> (Boolean)function.apply(((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft(), ((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)pair.getLeft()).getLeft()).getRight(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        public static <A, B, C, D, E, F, G, H, I> Predicate<Pair<Pair<Pair<Pair<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, F>, G>, H>, I>> test(Function9<A, B, C, D, E, F, G, H, I, Boolean> function) {
            return pair -> (Boolean)function.apply(((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft(), ((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)((Pair)pair.getLeft()).getLeft()).getLeft()).getRight(), ((Pair)((Pair)pair.getLeft()).getLeft()).getRight(), ((Pair)pair.getLeft()).getRight(), pair.getRight());
        }

        @FunctionalInterface
        public static interface Function9<A, B, C, D, E, F, G, H, I, R> {
            public R apply(A var1, B var2, C var3, D var4, E var5, F var6, G var7, H var8, I var9);
        }

        @FunctionalInterface
        public static interface Function8<A, B, C, D, E, F, G, H, R> {
            public R apply(A var1, B var2, C var3, D var4, E var5, F var6, G var7, H var8);
        }

        @FunctionalInterface
        public static interface Function7<A, B, C, D, E, F, G, R> {
            public R apply(A var1, B var2, C var3, D var4, E var5, F var6, G var7);
        }

        @FunctionalInterface
        public static interface Function6<A, B, C, D, E, F, R> {
            public R apply(A var1, B var2, C var3, D var4, E var5, F var6);
        }

        @FunctionalInterface
        public static interface Function5<A, B, C, D, E, R> {
            public R apply(A var1, B var2, C var3, D var4, E var5);
        }

        @FunctionalInterface
        public static interface Function4<A, B, C, D, R> {
            public R apply(A var1, B var2, C var3, D var4);
        }

        @FunctionalInterface
        public static interface Function3<A, B, C, R> {
            public R apply(A var1, B var2, C var3);
        }
    }

    public static final class Parsers {
        public static final Parser<?> EMPTY_PARSER = Parsers.success(UNIT);
        public static final Parser<?> BEGIN_PARSER = Parsers.regex("^").map(m -> UNIT);
        public static final Parser<?> END_PARSER = Parsers.regex("$").map(m -> UNIT);

        public static <R> Parser<R> success(R value) {
            return parserInput -> value;
        }

        public static <R> Parser<R> failure(String cause) {
            return parserInput -> {
                throw new ParserFailure(cause, parserInput);
            };
        }

        public static Parser<?> empty() {
            return EMPTY_PARSER;
        }

        public static Parser<?> begin() {
            return BEGIN_PARSER;
        }

        public static Parser<?> end() {
            return END_PARSER;
        }

        public static <R> Parser<R> oneOf(Stream<Parser<R>> parsers) {
            return parsers.reduce(Parser::or).orElse(Parsers.failure("No parsers given to choice parser."));
        }

        public static <R> Parser<R> oneOf(List<Parser<R>> parsers) {
            return Parsers.oneOf(parsers.stream());
        }

        @SafeVarargs
        public static <R> Parser<R> oneOf(Parser<R> ... parsers) {
            return Parsers.oneOf(Arrays.stream(parsers));
        }

        public static <R> Parser<List<R>> zeroOrMore(Parser<R> parser, Parser<?> separator) {
            return parserInput -> {
                ArrayList result = new ArrayList();
                do {
                    Optional element;
                    if (!(element = Parsers.peek(parser).tryParse(parserInput)).isPresent()) continue;
                    result.add(element.get());
                } while (Parsers.peek(separator).tryParse(parserInput).isPresent());
                return result;
            };
        }

        public static <R> Parser<List<R>> zeroOrMore(Parser<R> parser) {
            return parserInput -> {
                Optional element;
                ArrayList result = new ArrayList();
                while ((element = Parsers.peek(parser).tryParse(parserInput)).isPresent()) {
                    result.add(element.get());
                }
                return result;
            };
        }

        public static <R> Parser<List<R>> oneOrMore(Parser<R> parser) {
            return parserInput -> {
                Optional element;
                ArrayList result = new ArrayList();
                result.add(Parsers.peek(parser).parse(parserInput));
                while ((element = Parsers.peek(parser).tryParse(parserInput)).isPresent()) {
                    result.add(element.get());
                }
                return result;
            };
        }

        public static <R> Parser<List<R>> oneOrMore(Parser<R> parser, Parser<?> separator) {
            return parserInput -> {
                ArrayList result = new ArrayList();
                result.add(Parsers.peek(parser).parse(parserInput));
                try {
                    while (Parsers.peek(separator).tryParse(parserInput).isPresent()) {
                        result.add(Parsers.peek(parser).parse(parserInput));
                    }
                }
                finally {
                    return result;
                }
            };
        }

        public static SkipParser skip(Parser<?> parser) {
            return new SkipParser(parser);
        }

        public static Parser<Float> floatNumber() {
            return FloatParser.singleton;
        }

        public static <R> Parser<R> peek(Parser<R> parser) {
            return parserInput -> {
                CharSequence text = parserInput.getText();
                int offset = parserInput.getOffset();
                try {
                    return parser.parse(parserInput);
                }
                catch (ParserFailure e) {
                    parserInput.setText(text);
                    parserInput.setOffset(offset);
                    throw e;
                }
            };
        }

        public static <R> Parser<R> filter(Parser<R> parser, Predicate<R> predicate) {
            return parserInput -> {
                CharSequence text = parserInput.getText();
                int offset = parserInput.getOffset();
                Object result = Parsers.peek(parser).parse(parserInput);
                if (predicate.test(result)) {
                    return result;
                }
                parserInput.setText(text);
                parserInput.setOffset(offset);
                throw new ParserFailure(parserInput);
            };
        }

        public static <R> Parser<R> then(Supplier<Parser<R>> parser) {
            return parserInput -> ((Parser)parser.get()).parse(parserInput);
        }

        public static Parser<String> string(String string) {
            return Parsers.regex(Pattern.quote(string)).map(MatchResult::group);
        }

        public static Parser<MatchResult> regex(String regex) {
            return Parsers.regex(Pattern.compile(regex));
        }

        public static Parser<MatchResult> regex(Pattern pattern) {
            return new RegexParser(pattern);
        }
    }
}

