/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.servlet;

import com.nike.internal.util.StringUtils;
import com.nike.wingtips.Span;
import com.nike.wingtips.http.HttpRequestTracingUtils;
import com.nike.wingtips.http.RequestWithHeaders;
import com.nike.wingtips.servlet.RequestWithHeadersServletAdapter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpSpanFactory {
    protected static final String SPRING_BEST_MATCHING_PATTERN_REQUEST_ATTRIBUTE_KEY = "org.springframework.web.servlet.HandlerMapping.bestMatchingPattern";

    private HttpSpanFactory() {
    }

    public static Span fromHttpServletRequest(HttpServletRequest servletRequest, List<String> userIdHeaderKeys) {
        if (servletRequest == null) {
            return null;
        }
        return HttpRequestTracingUtils.fromRequestWithHeaders((RequestWithHeaders)new RequestWithHeadersServletAdapter(servletRequest), userIdHeaderKeys);
    }

    public static String getUserIdFromHttpServletRequest(HttpServletRequest servletRequest, List<String> userIdHeaderKeys) {
        if (servletRequest == null) {
            return null;
        }
        return HttpRequestTracingUtils.getUserIdFromRequestWithHeaders((RequestWithHeaders)new RequestWithHeadersServletAdapter(servletRequest), userIdHeaderKeys);
    }

    @Nullable
    public static String determineUriPathTemplate(@Nullable HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String path = HttpSpanFactory.getRequestAttributeAsString(request, "http.route");
        if (StringUtils.isNotBlank((CharSequence)path)) {
            return path;
        }
        path = HttpSpanFactory.getRequestAttributeAsString(request, SPRING_BEST_MATCHING_PATTERN_REQUEST_ATTRIBUTE_KEY);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            return path;
        }
        return null;
    }

    @NotNull
    public static String getSpanName(@Nullable HttpServletRequest request) {
        String pathTemplate = HttpSpanFactory.determineUriPathTemplate(request);
        String method = request == null ? null : request.getMethod();
        return HttpRequestTracingUtils.generateSafeSpanName((String)method, (String)pathTemplate, (Integer)null);
    }

    private static String getRequestAttributeAsString(HttpServletRequest request, String attrName) {
        Object attrValue = request.getAttribute(attrName);
        return attrValue == null ? null : attrValue.toString();
    }
}

