/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.servlet;

import com.nike.internal.util.Pair;
import com.nike.internal.util.StringUtils;
import com.nike.wingtips.Span;
import com.nike.wingtips.Tracer;
import com.nike.wingtips.servlet.HttpSpanFactory;
import com.nike.wingtips.servlet.ServletRuntime;
import com.nike.wingtips.servlet.tag.ServletRequestTagAdapter;
import com.nike.wingtips.tags.HttpTagAndSpanNamingAdapter;
import com.nike.wingtips.tags.HttpTagAndSpanNamingStrategy;
import com.nike.wingtips.tags.NoOpHttpTagStrategy;
import com.nike.wingtips.tags.OpenTracingHttpTagStrategy;
import com.nike.wingtips.tags.ZipkinHttpTagStrategy;
import com.nike.wingtips.util.AsyncWingtipsHelperJava7;
import com.nike.wingtips.util.TracingState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestTracingFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String FILTER_HAS_ALREADY_EXECUTED_ATTRIBUTE = "RequestTracingFilterAlreadyFiltered";
    @Deprecated
    public static final String ERROR_REQUEST_URI_ATTRIBUTE = "javax.servlet.error.request_uri";
    public static final String USER_ID_HEADER_KEYS_LIST_INIT_PARAM_NAME = "user-id-header-keys-list";
    public static final String TAG_AND_SPAN_NAMING_STRATEGY_INIT_PARAM_NAME = "server-side-span-tag-and-naming-strategy";
    public static final String TAG_AND_SPAN_NAMING_ADAPTER_INIT_PARAM_NAME = "server-side-span-tag-and-naming-adapter";
    protected ServletRuntime servletRuntime;
    protected List<String> userIdHeaderKeysFromInitParam;
    protected HttpTagAndSpanNamingStrategy<HttpServletRequest, HttpServletResponse> tagAndNamingStrategy;
    protected HttpTagAndSpanNamingAdapter<HttpServletRequest, HttpServletResponse> tagAndNamingAdapter;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.userIdHeaderKeysFromInitParam = this.initializeUserIdHeaderKeys(filterConfig);
        this.tagAndNamingStrategy = this.initializeTagAndNamingStrategy(filterConfig);
        this.tagAndNamingAdapter = this.initializeTagAndNamingAdapter(filterConfig);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean filterHasAlreadyExecuted;
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException(this.getClass().getName() + " only supports HTTP requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean bl = filterHasAlreadyExecuted = request.getAttribute(FILTER_HAS_ALREADY_EXECUTED_ATTRIBUTE) != null;
        if (filterHasAlreadyExecuted || this.skipDispatch(httpRequest)) {
            filterChain.doFilter(request, response);
        } else {
            request.setAttribute(FILTER_HAS_ALREADY_EXECUTED_ATTRIBUTE, (Object)Boolean.TRUE);
            this.doFilterInternal(httpRequest, httpResponse, filterChain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        TracingState originalThreadInfo = TracingState.getCurrentThreadTracingState();
        try {
            Span overallRequestSpan = this.createNewSpanForRequest(request);
            this.addTracingInfoToRequestAttributes(overallRequestSpan, request);
            response.setHeader("X-B3-TraceId", overallRequestSpan.getTraceId());
            TracingState originalRequestTracingState = TracingState.getCurrentThreadTracingState();
            Throwable errorForTagging = null;
            try {
                this.tagAndNamingStrategy.handleRequestTagging(overallRequestSpan, (Object)request, this.tagAndNamingAdapter);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (Throwable t) {
                errorForTagging = t;
                throw t;
            }
            finally {
                if (this.isAsyncRequest(request)) {
                    this.setupTracingCompletionWhenAsyncRequestCompletes(request, response, originalRequestTracingState, this.tagAndNamingStrategy, this.tagAndNamingAdapter);
                } else {
                    try {
                        this.tagAndNamingStrategy.handleResponseTaggingAndFinalSpanName(overallRequestSpan, (Object)request, (Object)response, errorForTagging, this.tagAndNamingAdapter);
                    }
                    finally {
                        Tracer.getInstance().completeRequestSpan();
                    }
                }
            }
        }
        finally {
            AsyncWingtipsHelperJava7.unlinkTracingFromCurrentThread((Pair)originalThreadInfo);
        }
    }

    protected Span createNewSpanForRequest(HttpServletRequest request) {
        Span newSpan;
        Tracer tracer = Tracer.getInstance();
        Span parentSpan = HttpSpanFactory.fromHttpServletRequest(request, this.getUserIdHeaderKeys());
        if (parentSpan != null) {
            this.logger.debug("Found parent Span {}", (Object)parentSpan);
            newSpan = tracer.startRequestWithChildSpan(parentSpan, this.getInitialSpanName(request, this.tagAndNamingStrategy, this.tagAndNamingAdapter));
        } else {
            newSpan = tracer.startRequestWithRootSpan(this.getInitialSpanName(request, this.tagAndNamingStrategy, this.tagAndNamingAdapter), HttpSpanFactory.getUserIdFromHttpServletRequest(request, this.getUserIdHeaderKeys()));
            this.logger.debug("Parent span not found, starting a new span {}", (Object)newSpan);
        }
        return newSpan;
    }

    protected void addTracingInfoToRequestAttributes(Span span, HttpServletRequest request) {
        request.setAttribute("X-B3-Sampled", (Object)span.isSampleable());
        request.setAttribute("X-B3-TraceId", (Object)span.getTraceId());
        request.setAttribute("X-B3-SpanId", (Object)span.getSpanId());
        request.setAttribute("X-B3-ParentSpanId", (Object)span.getParentSpanId());
        request.setAttribute("X-B3-SpanName", (Object)span.getSpanName());
        request.setAttribute(Span.class.getName(), (Object)span);
    }

    protected String getInitialSpanName(HttpServletRequest request, HttpTagAndSpanNamingStrategy<HttpServletRequest, ?> namingStrategy, HttpTagAndSpanNamingAdapter<HttpServletRequest, ?> adapter) {
        String spanNameFromStrategy = namingStrategy.getInitialSpanName((Object)request, adapter);
        if (StringUtils.isNotBlank((CharSequence)spanNameFromStrategy)) {
            return spanNameFromStrategy;
        }
        return HttpSpanFactory.getSpanName(request);
    }

    protected boolean skipDispatch(HttpServletRequest request) {
        return false;
    }

    @Deprecated
    protected boolean isAsyncDispatch(HttpServletRequest request) {
        return this.getServletRuntime((ServletRequest)request).isAsyncDispatch(request);
    }

    protected List<String> getUserIdHeaderKeys() {
        return this.userIdHeaderKeysFromInitParam;
    }

    protected ServletRuntime getServletRuntime(ServletRequest request) {
        if (this.servletRuntime == null) {
            this.servletRuntime = ServletRuntime.determineServletRuntime(request.getClass(), "javax.servlet.AsyncListener");
        }
        return this.servletRuntime;
    }

    protected boolean isAsyncRequest(HttpServletRequest request) {
        return this.getServletRuntime((ServletRequest)request).isAsyncRequest(request);
    }

    protected void setupTracingCompletionWhenAsyncRequestCompletes(HttpServletRequest asyncRequest, HttpServletResponse asyncResponse, TracingState originalRequestTracingState, HttpTagAndSpanNamingStrategy<HttpServletRequest, HttpServletResponse> tagAndNamingStrategy, HttpTagAndSpanNamingAdapter<HttpServletRequest, HttpServletResponse> tagAndNamingAdapter) {
        this.getServletRuntime((ServletRequest)asyncRequest).setupTracingCompletionWhenAsyncRequestCompletes(asyncRequest, asyncResponse, originalRequestTracingState, tagAndNamingStrategy, tagAndNamingAdapter);
    }

    protected List<String> initializeUserIdHeaderKeys(FilterConfig filterConfig) {
        String userIdHeaderKeysListString = filterConfig.getInitParameter(USER_ID_HEADER_KEYS_LIST_INIT_PARAM_NAME);
        if (userIdHeaderKeysListString != null) {
            ArrayList<String> parsedList = new ArrayList<String>();
            for (String headerKey : userIdHeaderKeysListString.split(",")) {
                String trimmedHeaderKey = headerKey.trim();
                if (trimmedHeaderKey.length() <= 0) continue;
                parsedList.add(trimmedHeaderKey);
            }
            return Collections.unmodifiableList(parsedList);
        }
        return null;
    }

    protected HttpTagAndSpanNamingStrategy<HttpServletRequest, HttpServletResponse> initializeTagAndNamingStrategy(FilterConfig filterConfig) {
        String tagStrategyString = filterConfig.getInitParameter(TAG_AND_SPAN_NAMING_STRATEGY_INIT_PARAM_NAME);
        try {
            return this.getTagStrategyFromName(tagStrategyString);
        }
        catch (Throwable t) {
            this.logger.warn("Unable to match tagging strategy " + tagStrategyString + ". Using default Zipkin strategy", t);
            return this.getDefaultTagStrategy();
        }
    }

    protected HttpTagAndSpanNamingAdapter<HttpServletRequest, HttpServletResponse> initializeTagAndNamingAdapter(FilterConfig filterConfig) {
        String tagAdapterString = filterConfig.getInitParameter(TAG_AND_SPAN_NAMING_ADAPTER_INIT_PARAM_NAME);
        try {
            return this.getTagAdapterFromName(tagAdapterString);
        }
        catch (Throwable t) {
            this.logger.warn("Unable to match tagging adapter " + tagAdapterString + ". Using default ServletRequestTagAdapter", t);
            return this.getDefaultTagAdapter();
        }
    }

    protected HttpTagAndSpanNamingStrategy<HttpServletRequest, HttpServletResponse> getTagStrategyFromName(String strategyName) throws ClassNotFoundException, IllegalAccessException, InstantiationException, ClassCastException {
        if (StringUtils.isBlank((CharSequence)strategyName) || "zipkin".equalsIgnoreCase(strategyName)) {
            return this.getZipkinHttpTagStrategy();
        }
        if ("opentracing".equalsIgnoreCase(strategyName)) {
            return this.getOpenTracingHttpTagStrategy();
        }
        if ("none".equalsIgnoreCase(strategyName) || "noop".equalsIgnoreCase(strategyName)) {
            return this.getNoOpTagStrategy();
        }
        return (HttpTagAndSpanNamingStrategy)Class.forName(strategyName).newInstance();
    }

    protected HttpTagAndSpanNamingAdapter<HttpServletRequest, HttpServletResponse> getTagAdapterFromName(String adapterName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (StringUtils.isBlank((CharSequence)adapterName)) {
            return this.getDefaultTagAdapter();
        }
        return (HttpTagAndSpanNamingAdapter)Class.forName(adapterName).newInstance();
    }

    protected HttpTagAndSpanNamingStrategy<HttpServletRequest, HttpServletResponse> getZipkinHttpTagStrategy() {
        return ZipkinHttpTagStrategy.getDefaultInstance();
    }

    protected HttpTagAndSpanNamingStrategy<HttpServletRequest, HttpServletResponse> getOpenTracingHttpTagStrategy() {
        return OpenTracingHttpTagStrategy.getDefaultInstance();
    }

    protected HttpTagAndSpanNamingStrategy<HttpServletRequest, HttpServletResponse> getNoOpTagStrategy() {
        return NoOpHttpTagStrategy.getDefaultInstance();
    }

    protected HttpTagAndSpanNamingStrategy<HttpServletRequest, HttpServletResponse> getDefaultTagStrategy() {
        return this.getZipkinHttpTagStrategy();
    }

    protected HttpTagAndSpanNamingAdapter<HttpServletRequest, HttpServletResponse> getDefaultTagAdapter() {
        return ServletRequestTagAdapter.getDefaultInstance();
    }
}

