/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.servlet;

import com.nike.wingtips.servlet.WingtipsRequestSpanCompletionAsyncListener;
import com.nike.wingtips.tags.HttpTagAndSpanNamingAdapter;
import com.nike.wingtips.tags.HttpTagAndSpanNamingStrategy;
import com.nike.wingtips.util.TracingState;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ServletRuntime {
    private static final Logger logger = LoggerFactory.getLogger(ServletRuntime.class);
    static final String ASYNC_LISTENER_CLASSNAME = "javax.servlet.AsyncListener";

    ServletRuntime() {
    }

    abstract boolean isAsyncRequest(HttpServletRequest var1);

    abstract void setupTracingCompletionWhenAsyncRequestCompletes(HttpServletRequest var1, HttpServletResponse var2, TracingState var3, HttpTagAndSpanNamingStrategy<HttpServletRequest, HttpServletResponse> var4, HttpTagAndSpanNamingAdapter<HttpServletRequest, HttpServletResponse> var5);

    @Deprecated
    abstract boolean isAsyncDispatch(HttpServletRequest var1);

    static ServletRuntime determineServletRuntime(Class<?> servletRequestClass, String asyncListenerClassname) {
        try {
            servletRequestClass.getMethod("getAsyncContext", new Class[0]);
            Class.forName(asyncListenerClassname);
            return new Servlet3Runtime();
        }
        catch (Exception ex) {
            logger.warn("Servlet 3 async requests are not supported on the current container. RequestTracingFilter will default to blocking request behavior (Servlet 2.x). Exception message indicating a Servlet 2.x environment: {}", (Object)ex.toString());
            return new Servlet2Runtime();
        }
    }

    static class Servlet3Runtime
    extends ServletRuntime {
        Servlet3Runtime() {
        }

        @Override
        public boolean isAsyncRequest(HttpServletRequest request) {
            return request.isAsyncStarted();
        }

        @Override
        public void setupTracingCompletionWhenAsyncRequestCompletes(HttpServletRequest asyncRequest, HttpServletResponse asyncResponse, TracingState originalRequestTracingState, HttpTagAndSpanNamingStrategy<HttpServletRequest, HttpServletResponse> tagAndNamingStrategy, HttpTagAndSpanNamingAdapter<HttpServletRequest, HttpServletResponse> tagAndNamingAdapter) {
            asyncRequest.getAsyncContext().addListener((AsyncListener)new WingtipsRequestSpanCompletionAsyncListener(originalRequestTracingState, tagAndNamingStrategy, tagAndNamingAdapter), (ServletRequest)asyncRequest, (ServletResponse)asyncResponse);
        }

        @Override
        boolean isAsyncDispatch(HttpServletRequest request) {
            return "ASYNC".equals(request.getDispatcherType().name());
        }
    }

    static class Servlet2Runtime
    extends ServletRuntime {
        Servlet2Runtime() {
        }

        @Override
        public boolean isAsyncRequest(HttpServletRequest request) {
            return false;
        }

        @Override
        public void setupTracingCompletionWhenAsyncRequestCompletes(HttpServletRequest asyncRequest, HttpServletResponse asyncResponse, TracingState originalRequestTracingState, HttpTagAndSpanNamingStrategy<HttpServletRequest, HttpServletResponse> tagAndNamingStrategy, HttpTagAndSpanNamingAdapter<HttpServletRequest, HttpServletResponse> tagAndNamingAdapter) {
            throw new IllegalStateException("This method should never be called in a pre-Servlet-3.0 environment.");
        }

        @Override
        boolean isAsyncDispatch(HttpServletRequest request) {
            return false;
        }
    }
}

