/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.servlet;

import com.nike.internal.util.Pair;
import com.nike.wingtips.Span;
import com.nike.wingtips.Tracer;
import com.nike.wingtips.tags.HttpTagAndSpanNamingAdapter;
import com.nike.wingtips.tags.HttpTagAndSpanNamingStrategy;
import com.nike.wingtips.tags.NoOpHttpTagAdapter;
import com.nike.wingtips.tags.NoOpHttpTagStrategy;
import com.nike.wingtips.util.AsyncWingtipsHelperJava7;
import com.nike.wingtips.util.TracingState;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class WingtipsRequestSpanCompletionAsyncListener
implements AsyncListener {
    protected final TracingState originalRequestTracingState;
    protected final AtomicBoolean alreadyCompleted = new AtomicBoolean(false);
    protected final HttpTagAndSpanNamingStrategy<HttpServletRequest, HttpServletResponse> tagAndNamingStrategy;
    protected final HttpTagAndSpanNamingAdapter<HttpServletRequest, HttpServletResponse> tagAndNamingAdapter;

    WingtipsRequestSpanCompletionAsyncListener(TracingState originalRequestTracingState, HttpTagAndSpanNamingStrategy<HttpServletRequest, HttpServletResponse> tagAndNamingStrategy, HttpTagAndSpanNamingAdapter<HttpServletRequest, HttpServletResponse> tagAndNamingAdapter) {
        this.originalRequestTracingState = originalRequestTracingState;
        if (tagAndNamingStrategy == null) {
            tagAndNamingStrategy = NoOpHttpTagStrategy.getDefaultInstance();
        }
        if (tagAndNamingAdapter == null) {
            tagAndNamingAdapter = NoOpHttpTagAdapter.getDefaultInstance();
        }
        this.tagAndNamingStrategy = tagAndNamingStrategy;
        this.tagAndNamingAdapter = tagAndNamingAdapter;
    }

    public void onComplete(AsyncEvent event) {
        this.completeRequestSpan(event);
    }

    public void onTimeout(AsyncEvent event) {
    }

    public void onError(AsyncEvent event) {
    }

    public void onStartAsync(AsyncEvent event) {
        AsyncContext eventAsyncContext = event.getAsyncContext();
        if (eventAsyncContext != null) {
            eventAsyncContext.addListener((AsyncListener)this, event.getSuppliedRequest(), event.getSuppliedResponse());
        }
    }

    protected void completeRequestSpan(AsyncEvent event) {
        if (this.alreadyCompleted.getAndSet(true)) {
            return;
        }
        ServletRequest request = event.getSuppliedRequest();
        ServletResponse response = event.getSuppliedResponse();
        final HttpServletRequest httpRequest = request instanceof HttpServletRequest ? (HttpServletRequest)request : null;
        final HttpServletResponse httpResponse = response instanceof HttpServletResponse ? (HttpServletResponse)response : null;
        final Throwable error = event.getThrowable();
        AsyncWingtipsHelperJava7.runnableWithTracing((Runnable)new Runnable(){

            @Override
            public void run() {
                Span span = Tracer.getInstance().getCurrentSpan();
                try {
                    WingtipsRequestSpanCompletionAsyncListener.this.tagAndNamingStrategy.handleResponseTaggingAndFinalSpanName(span, (Object)httpRequest, (Object)httpResponse, error, WingtipsRequestSpanCompletionAsyncListener.this.tagAndNamingAdapter);
                }
                finally {
                    Tracer.getInstance().completeRequestSpan();
                }
            }
        }, (Pair)this.originalRequestTracingState).run();
    }
}

