/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.servlet.tag;

import com.nike.internal.util.StringUtils;
import com.nike.wingtips.servlet.HttpSpanFactory;
import com.nike.wingtips.tags.HttpTagAndSpanNamingAdapter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServletRequestTagAdapter
extends HttpTagAndSpanNamingAdapter<HttpServletRequest, HttpServletResponse> {
    protected static final ServletRequestTagAdapter DEFAULT_INSTANCE = new ServletRequestTagAdapter();

    public static ServletRequestTagAdapter getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    @Nullable
    public String getErrorResponseTagValue(@Nullable HttpServletResponse response) {
        Integer statusCode = this.getResponseHttpStatus(response);
        if (statusCode != null && statusCode >= 500) {
            return statusCode.toString();
        }
        return null;
    }

    @Nullable
    public String getRequestUrl(@Nullable HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        StringBuffer requestUrl = request.getRequestURL();
        String queryString = request.getQueryString();
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            requestUrl.append('?').append(queryString);
        }
        return requestUrl.toString();
    }

    @Nullable
    public Integer getResponseHttpStatus(@Nullable HttpServletResponse response) {
        if (response == null) {
            return null;
        }
        return response.getStatus();
    }

    @Nullable
    public String getRequestHttpMethod(@Nullable HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return request.getMethod();
    }

    @Nullable
    public String getRequestPath(@Nullable HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return request.getRequestURI();
    }

    @Nullable
    public String getRequestUriPathTemplate(@Nullable HttpServletRequest request, @Nullable HttpServletResponse response) {
        return HttpSpanFactory.determineUriPathTemplate(request);
    }

    @Nullable
    public String getHeaderSingleValue(@Nullable HttpServletRequest request, @NotNull String headerKey) {
        if (request == null) {
            return null;
        }
        return request.getHeader(headerKey);
    }

    @Nullable
    public List<String> getHeaderMultipleValue(@Nullable HttpServletRequest request, @NotNull String headerKey) {
        if (request == null) {
            return null;
        }
        Enumeration matchingHeadersEnum = request.getHeaders(headerKey);
        if (matchingHeadersEnum == null) {
            return null;
        }
        return Collections.list(matchingHeadersEnum);
    }

    @Nullable
    public String getSpanHandlerTagValue(@Nullable HttpServletRequest request, @Nullable HttpServletResponse response) {
        return "servlet";
    }
}

