/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.springboot;

import com.nike.wingtips.Tracer;
import com.nike.wingtips.servlet.RequestTracingFilter;
import com.nike.wingtips.springboot.WingtipsSpringBootProperties;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={WingtipsSpringBootProperties.class})
public class WingtipsSpringBootConfiguration {
    @Autowired(required=false)
    protected RequestTracingFilter requestTracingFilter;
    protected WingtipsSpringBootProperties wingtipsProperties;

    @Autowired
    public WingtipsSpringBootConfiguration(WingtipsSpringBootProperties wingtipsProperties) {
        this.wingtipsProperties = wingtipsProperties;
        if (wingtipsProperties.getSpanLoggingFormat() != null) {
            Tracer.getInstance().setSpanLoggingRepresentation(wingtipsProperties.getSpanLoggingFormat());
        }
    }

    @Bean
    @ConditionalOnWebApplication
    public FilterRegistrationBean wingtipsRequestTracingFilter() {
        if (this.wingtipsProperties.isWingtipsDisabled()) {
            return new FilterRegistrationBean((Filter)new DoNothingServletFilter(), new ServletRegistrationBean[0]);
        }
        if (this.requestTracingFilter == null) {
            this.requestTracingFilter = new RequestTracingFilter();
        }
        FilterRegistrationBean frb = new FilterRegistrationBean((Filter)this.requestTracingFilter, new ServletRegistrationBean[0]);
        if (this.wingtipsProperties.getUserIdHeaderKeys() != null) {
            frb.addInitParameter("user-id-header-keys-list", this.wingtipsProperties.getUserIdHeaderKeys());
        }
        if (this.wingtipsProperties.getServerSideSpanTaggingStrategy() != null) {
            frb.addInitParameter("server-side-span-tag-and-naming-strategy", this.wingtipsProperties.getServerSideSpanTaggingStrategy());
        }
        if (this.wingtipsProperties.getServerSideSpanTaggingAdapter() != null) {
            frb.addInitParameter("server-side-span-tag-and-naming-adapter", this.wingtipsProperties.getServerSideSpanTaggingAdapter());
        }
        frb.setOrder(Integer.MIN_VALUE);
        return frb;
    }

    protected static class DoNothingServletFilter
    implements Filter {
        protected DoNothingServletFilter() {
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

