/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.spring.interceptor;

import com.nike.internal.util.Pair;
import com.nike.internal.util.StringUtils;
import com.nike.wingtips.Span;
import com.nike.wingtips.Tracer;
import com.nike.wingtips.http.HttpRequestTracingUtils;
import com.nike.wingtips.spring.interceptor.tag.SpringHttpClientTagAdapter;
import com.nike.wingtips.spring.util.HttpRequestWrapperWithModifiableHeaders;
import com.nike.wingtips.spring.util.WingtipsSpringUtil;
import com.nike.wingtips.tags.HttpTagAndSpanNamingAdapter;
import com.nike.wingtips.tags.HttpTagAndSpanNamingStrategy;
import com.nike.wingtips.tags.ZipkinHttpTagStrategy;
import com.nike.wingtips.util.AsyncWingtipsHelperJava7;
import com.nike.wingtips.util.TracingState;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestExecution;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class WingtipsAsyncClientHttpRequestInterceptor
implements AsyncClientHttpRequestInterceptor {
    public static final WingtipsAsyncClientHttpRequestInterceptor DEFAULT_IMPL = new WingtipsAsyncClientHttpRequestInterceptor();
    protected final boolean surroundCallsWithSubspan;
    protected final HttpTagAndSpanNamingStrategy<HttpRequest, ClientHttpResponse> tagAndNamingStrategy;
    protected final HttpTagAndSpanNamingAdapter<HttpRequest, ClientHttpResponse> tagAndNamingAdapter;

    public WingtipsAsyncClientHttpRequestInterceptor() {
        this(true);
    }

    public WingtipsAsyncClientHttpRequestInterceptor(boolean surroundCallsWithSubspan) {
        this(surroundCallsWithSubspan, (HttpTagAndSpanNamingStrategy<HttpRequest, ClientHttpResponse>)ZipkinHttpTagStrategy.getDefaultInstance(), SpringHttpClientTagAdapter.getDefaultInstance());
    }

    public WingtipsAsyncClientHttpRequestInterceptor(boolean surroundCallsWithSubspan, HttpTagAndSpanNamingStrategy<HttpRequest, ClientHttpResponse> tagAndNamingStrategy, HttpTagAndSpanNamingAdapter<HttpRequest, ClientHttpResponse> tagAndNamingAdapter) {
        if (tagAndNamingStrategy == null) {
            throw new IllegalArgumentException("tagAndNamingStrategy cannot be null - if you really want no strategy, use NoOpHttpTagStrategy");
        }
        if (tagAndNamingAdapter == null) {
            throw new IllegalArgumentException("tagAndNamingAdapter cannot be null - if you really want no adapter, use NoOpHttpTagAdapter");
        }
        this.surroundCallsWithSubspan = surroundCallsWithSubspan;
        this.tagAndNamingStrategy = tagAndNamingStrategy;
        this.tagAndNamingAdapter = tagAndNamingAdapter;
    }

    public ListenableFuture<ClientHttpResponse> intercept(HttpRequest request, byte[] body, AsyncClientHttpRequestExecution execution) throws IOException {
        HttpRequestWrapperWithModifiableHeaders wrapperRequest = new HttpRequestWrapperWithModifiableHeaders(request);
        if (this.surroundCallsWithSubspan) {
            return this.createAsyncSubSpanAndExecute(wrapperRequest, body, execution);
        }
        return this.propagateTracingHeadersAndExecute(wrapperRequest, body, execution);
    }

    protected ListenableFuture<ClientHttpResponse> propagateTracingHeadersAndExecute(HttpRequestWrapperWithModifiableHeaders wrapperRequest, byte[] body, AsyncClientHttpRequestExecution execution) throws IOException {
        WingtipsSpringUtil.propagateTracingHeaders((HttpMessage)wrapperRequest, Tracer.getInstance().getCurrentSpan());
        return execution.executeAsync((HttpRequest)wrapperRequest, body);
    }

    protected ListenableFuture<ClientHttpResponse> createAsyncSubSpanAndExecute(HttpRequestWrapperWithModifiableHeaders wrapperRequest, byte[] body, AsyncClientHttpRequestExecution execution) throws IOException {
        TracingState originalThreadInfo = TracingState.getCurrentThreadTracingState();
        SpanAroundAsyncCallFinisher subspanFinisher = null;
        try {
            Span subspan = Tracer.getInstance().startSpanInCurrentContext(this.getSubspanSpanName((HttpRequest)wrapperRequest, this.tagAndNamingStrategy, this.tagAndNamingAdapter), Span.SpanPurpose.CLIENT);
            this.tagAndNamingStrategy.handleRequestTagging(subspan, (Object)wrapperRequest, this.tagAndNamingAdapter);
            subspanFinisher = new SpanAroundAsyncCallFinisher(TracingState.getCurrentThreadTracingState(), (HttpRequest)wrapperRequest, this.tagAndNamingStrategy, this.tagAndNamingAdapter);
            ListenableFuture<ClientHttpResponse> result = this.propagateTracingHeadersAndExecute(wrapperRequest, body, execution);
            result.addCallback((ListenableFutureCallback)subspanFinisher);
            ListenableFuture<ClientHttpResponse> listenableFuture = result;
            return listenableFuture;
        }
        catch (Throwable t) {
            if (subspanFinisher != null) {
                subspanFinisher.finishCallSpan(null, t);
            }
            throw t;
        }
        finally {
            AsyncWingtipsHelperJava7.unlinkTracingFromCurrentThread((Pair)originalThreadInfo);
        }
    }

    @NotNull
    protected String getSubspanSpanName(@NotNull HttpRequest request, @NotNull HttpTagAndSpanNamingStrategy<HttpRequest, ?> namingStrategy, @NotNull HttpTagAndSpanNamingAdapter<HttpRequest, ?> adapter) {
        String subspanNameFromStrategy = namingStrategy.getInitialSpanName((Object)request, adapter);
        if (StringUtils.isNotBlank((CharSequence)subspanNameFromStrategy)) {
            return subspanNameFromStrategy;
        }
        return HttpRequestTracingUtils.getFallbackSpanNameForHttpRequest((String)"asyncresttemplate_downstream_call", (String)WingtipsSpringUtil.getRequestMethodAsString(request.getMethod()));
    }

    protected static class SpanAroundAsyncCallFinisher
    implements ListenableFutureCallback<ClientHttpResponse> {
        protected final TracingState spanAroundCallTracingState;
        protected final HttpRequest request;
        protected final HttpTagAndSpanNamingStrategy<HttpRequest, ClientHttpResponse> tagAndNamingStrategy;
        protected final HttpTagAndSpanNamingAdapter<HttpRequest, ClientHttpResponse> tagAndNamingAdapter;

        protected SpanAroundAsyncCallFinisher(TracingState spanAroundCallTracingState, HttpRequest request, HttpTagAndSpanNamingStrategy<HttpRequest, ClientHttpResponse> tagAndNamingStrategy, HttpTagAndSpanNamingAdapter<HttpRequest, ClientHttpResponse> tagAndNamingAdapter) {
            this.spanAroundCallTracingState = spanAroundCallTracingState;
            this.request = request;
            this.tagAndNamingStrategy = tagAndNamingStrategy;
            this.tagAndNamingAdapter = tagAndNamingAdapter;
        }

        public void onFailure(Throwable ex) {
            this.finishCallSpan(null, ex);
        }

        public void onSuccess(ClientHttpResponse result) {
            this.finishCallSpan(result, null);
        }

        protected void finishCallSpan(final ClientHttpResponse response, final Throwable error) {
            if (this.spanAroundCallTracingState != null) {
                AsyncWingtipsHelperJava7.runnableWithTracing((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try (Span span = Tracer.getInstance().getCurrentSpan();){
                            SpanAroundAsyncCallFinisher.this.tagAndNamingStrategy.handleResponseTaggingAndFinalSpanName(span, (Object)SpanAroundAsyncCallFinisher.this.request, (Object)response, error, SpanAroundAsyncCallFinisher.this.tagAndNamingAdapter);
                        }
                    }
                }, (Pair)this.spanAroundCallTracingState).run();
            }
        }
    }
}

