/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.spring.interceptor;

import com.nike.internal.util.StringUtils;
import com.nike.wingtips.Span;
import com.nike.wingtips.Tracer;
import com.nike.wingtips.http.HttpRequestTracingUtils;
import com.nike.wingtips.spring.interceptor.tag.SpringHttpClientTagAdapter;
import com.nike.wingtips.spring.util.HttpRequestWrapperWithModifiableHeaders;
import com.nike.wingtips.spring.util.WingtipsSpringUtil;
import com.nike.wingtips.tags.HttpTagAndSpanNamingAdapter;
import com.nike.wingtips.tags.HttpTagAndSpanNamingStrategy;
import com.nike.wingtips.tags.ZipkinHttpTagStrategy;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class WingtipsClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    public static final WingtipsClientHttpRequestInterceptor DEFAULT_IMPL = new WingtipsClientHttpRequestInterceptor();
    protected final boolean surroundCallsWithSubspan;
    protected final HttpTagAndSpanNamingStrategy<HttpRequest, ClientHttpResponse> tagAndNamingStrategy;
    protected final HttpTagAndSpanNamingAdapter<HttpRequest, ClientHttpResponse> tagAndNamingAdapter;

    public WingtipsClientHttpRequestInterceptor() {
        this(true);
    }

    public WingtipsClientHttpRequestInterceptor(boolean surroundCallsWithSubspan) {
        this(surroundCallsWithSubspan, (HttpTagAndSpanNamingStrategy<HttpRequest, ClientHttpResponse>)ZipkinHttpTagStrategy.getDefaultInstance(), SpringHttpClientTagAdapter.getDefaultInstance());
    }

    public WingtipsClientHttpRequestInterceptor(boolean surroundCallsWithSubspan, HttpTagAndSpanNamingStrategy<HttpRequest, ClientHttpResponse> tagAndNamingStrategy, HttpTagAndSpanNamingAdapter<HttpRequest, ClientHttpResponse> tagAndNamingAdapter) {
        if (tagAndNamingStrategy == null) {
            throw new IllegalArgumentException("tagAndNamingStrategy cannot be null - if you really want no strategy, use NoOpHttpTagStrategy");
        }
        if (tagAndNamingAdapter == null) {
            throw new IllegalArgumentException("tagAndNamingAdapter cannot be null - if you really want no adapter, use NoOpHttpTagAdapter");
        }
        this.surroundCallsWithSubspan = surroundCallsWithSubspan;
        this.tagAndNamingStrategy = tagAndNamingStrategy;
        this.tagAndNamingAdapter = tagAndNamingAdapter;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpRequestWrapperWithModifiableHeaders wrapperRequest = new HttpRequestWrapperWithModifiableHeaders(request);
        if (this.surroundCallsWithSubspan) {
            return this.createNewSpanAndExecuteRequest(wrapperRequest, body, execution);
        }
        return this.propagateTracingHeadersAndExecuteRequest(wrapperRequest, body, execution);
    }

    protected ClientHttpResponse propagateTracingHeadersAndExecuteRequest(HttpRequestWrapperWithModifiableHeaders wrapperRequest, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        WingtipsSpringUtil.propagateTracingHeaders((HttpMessage)wrapperRequest, Tracer.getInstance().getCurrentSpan());
        return execution.execute((HttpRequest)wrapperRequest, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ClientHttpResponse createNewSpanAndExecuteRequest(HttpRequestWrapperWithModifiableHeaders wrapperRequest, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse clientHttpResponse;
        Span spanAroundCall = Tracer.getInstance().startSpanInCurrentContext(this.getSubspanSpanName((HttpRequest)wrapperRequest, this.tagAndNamingStrategy, this.tagAndNamingAdapter), Span.SpanPurpose.CLIENT);
        Throwable errorForTagging = null;
        ClientHttpResponse response = null;
        try {
            this.tagAndNamingStrategy.handleRequestTagging(spanAroundCall, (Object)wrapperRequest, this.tagAndNamingAdapter);
            clientHttpResponse = response = this.propagateTracingHeadersAndExecuteRequest(wrapperRequest, body, execution);
        }
        catch (Throwable exception) {
            try {
                errorForTagging = exception;
                throw exception;
            }
            catch (Throwable throwable) {
                try {
                    this.tagAndNamingStrategy.handleResponseTaggingAndFinalSpanName(spanAroundCall, (Object)wrapperRequest, response, errorForTagging, this.tagAndNamingAdapter);
                    throw throwable;
                }
                finally {
                    spanAroundCall.close();
                }
            }
        }
        try {
            this.tagAndNamingStrategy.handleResponseTaggingAndFinalSpanName(spanAroundCall, (Object)wrapperRequest, (Object)response, errorForTagging, this.tagAndNamingAdapter);
            return clientHttpResponse;
        }
        finally {
            spanAroundCall.close();
        }
    }

    @NotNull
    protected String getSubspanSpanName(@NotNull HttpRequest request, @NotNull HttpTagAndSpanNamingStrategy<HttpRequest, ?> namingStrategy, @NotNull HttpTagAndSpanNamingAdapter<HttpRequest, ?> adapter) {
        String subspanNameFromStrategy = namingStrategy.getInitialSpanName((Object)request, adapter);
        if (StringUtils.isNotBlank((CharSequence)subspanNameFromStrategy)) {
            return subspanNameFromStrategy;
        }
        return HttpRequestTracingUtils.getFallbackSpanNameForHttpRequest((String)"resttemplate_downstream_call", (String)WingtipsSpringUtil.getRequestMethodAsString(request.getMethod()));
    }
}

