/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.spring.interceptor.tag;

import com.nike.wingtips.tags.HttpTagAndSpanNamingAdapter;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpRequestWrapper;

public class SpringHttpClientTagAdapter
extends HttpTagAndSpanNamingAdapter<HttpRequest, ClientHttpResponse> {
    protected static final SpringHttpClientTagAdapter DEFAULT_INSTANCE = new SpringHttpClientTagAdapter();

    public static SpringHttpClientTagAdapter getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    @Nullable
    public String getRequestUrl(@Nullable HttpRequest request) {
        if (request == null) {
            return null;
        }
        return request.getURI().toString();
    }

    @Nullable
    public Integer getResponseHttpStatus(@Nullable ClientHttpResponse response) {
        if (response == null) {
            return null;
        }
        try {
            return response.getRawStatusCode();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Nullable
    public String getRequestHttpMethod(@Nullable HttpRequest request) {
        if (request == null) {
            return null;
        }
        HttpMethod method = request.getMethod();
        return method == null ? "UNKNOWN_HTTP_METHOD" : method.name();
    }

    @Nullable
    public String getRequestUriPathTemplate(@Nullable HttpRequest request, @Nullable ClientHttpResponse response) {
        return null;
    }

    @Nullable
    public String getRequestPath(@Nullable HttpRequest request) {
        if (request == null) {
            return null;
        }
        return request.getURI().getPath();
    }

    @Nullable
    public String getHeaderSingleValue(@Nullable HttpRequest request, @NotNull String headerKey) {
        if (request == null) {
            return null;
        }
        return request.getHeaders().getFirst(headerKey);
    }

    @Nullable
    public List<String> getHeaderMultipleValue(@Nullable HttpRequest request, @NotNull String headerKey) {
        if (request == null) {
            return null;
        }
        return request.getHeaders().getValuesAsList(headerKey);
    }

    @Nullable
    public String getSpanHandlerTagValue(@Nullable HttpRequest request, @Nullable ClientHttpResponse response) {
        if (request instanceof HttpRequestWrapper) {
            request = ((HttpRequestWrapper)request).getRequest();
        }
        if (request instanceof AsyncClientHttpRequest) {
            return "spring.asyncresttemplate";
        }
        return "spring.resttemplate";
    }
}

