/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.spring.util;

import com.nike.internal.util.Pair;
import com.nike.wingtips.Span;
import com.nike.wingtips.http.HttpObjectForPropagation;
import com.nike.wingtips.http.HttpRequestTracingUtils;
import com.nike.wingtips.spring.interceptor.WingtipsAsyncClientHttpRequestInterceptor;
import com.nike.wingtips.spring.interceptor.WingtipsClientHttpRequestInterceptor;
import com.nike.wingtips.spring.util.HttpHeadersForPropagation;
import com.nike.wingtips.spring.util.asynchelperwrapper.FailureCallbackWithTracing;
import com.nike.wingtips.spring.util.asynchelperwrapper.ListenableFutureCallbackWithTracing;
import com.nike.wingtips.spring.util.asynchelperwrapper.SuccessCallbackWithTracing;
import com.nike.wingtips.tags.HttpTagAndSpanNamingAdapter;
import com.nike.wingtips.tags.HttpTagAndSpanNamingStrategy;
import java.util.Deque;
import java.util.Map;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.RestTemplate;

public class WingtipsSpringUtil {
    protected WingtipsSpringUtil() {
    }

    public static RestTemplate createTracingEnabledRestTemplate() {
        return WingtipsSpringUtil.createTracingEnabledRestTemplate(true);
    }

    public static RestTemplate createTracingEnabledRestTemplate(boolean surroundCallsWithSubspan) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getInterceptors().add(new WingtipsClientHttpRequestInterceptor(surroundCallsWithSubspan));
        return restTemplate;
    }

    public static RestTemplate createTracingEnabledRestTemplate(boolean surroundCallsWithSubspan, HttpTagAndSpanNamingStrategy<HttpRequest, ClientHttpResponse> tagAndNamingStrategy, HttpTagAndSpanNamingAdapter<HttpRequest, ClientHttpResponse> tagAndNamingAdapter) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getInterceptors().add(new WingtipsClientHttpRequestInterceptor(surroundCallsWithSubspan, tagAndNamingStrategy, tagAndNamingAdapter));
        return restTemplate;
    }

    public static AsyncRestTemplate createTracingEnabledAsyncRestTemplate() {
        return WingtipsSpringUtil.createTracingEnabledAsyncRestTemplate(true);
    }

    public static AsyncRestTemplate createTracingEnabledAsyncRestTemplate(boolean surroundCallsWithSubspan) {
        AsyncRestTemplate asyncRestTemplate = new AsyncRestTemplate();
        asyncRestTemplate.getInterceptors().add(new WingtipsAsyncClientHttpRequestInterceptor(surroundCallsWithSubspan));
        return asyncRestTemplate;
    }

    public static AsyncRestTemplate createTracingEnabledAsyncRestTemplate(boolean surroundCallsWithSubspan, HttpTagAndSpanNamingStrategy<HttpRequest, ClientHttpResponse> tagAndNamingStrategy, HttpTagAndSpanNamingAdapter<HttpRequest, ClientHttpResponse> tagAndNamingAdapter) {
        AsyncRestTemplate asyncRestTemplate = new AsyncRestTemplate();
        asyncRestTemplate.getInterceptors().add(new WingtipsAsyncClientHttpRequestInterceptor(surroundCallsWithSubspan, tagAndNamingStrategy, tagAndNamingAdapter));
        return asyncRestTemplate;
    }

    public static void propagateTracingHeaders(HttpMessage httpMessage, Span span) {
        HttpHeadersForPropagation headersForPropagation = httpMessage == null ? null : new HttpHeadersForPropagation(httpMessage);
        HttpRequestTracingUtils.propagateTracingHeaders((HttpObjectForPropagation)headersForPropagation, (Span)span);
    }

    public static String getRequestMethodAsString(HttpMethod method) {
        if (method == null) {
            return "UNKNOWN_HTTP_METHOD";
        }
        return method.name();
    }

    public static <T> SuccessCallback<T> successCallbackWithTracing(SuccessCallback<T> successCallback) {
        return new SuccessCallbackWithTracing<T>(successCallback);
    }

    public static <T> SuccessCallback<T> successCallbackWithTracing(SuccessCallback<T> successCallback, Pair<Deque<Span>, Map<String, String>> threadInfoToLink) {
        return new SuccessCallbackWithTracing<T>(successCallback, threadInfoToLink);
    }

    public static <T> SuccessCallback<T> successCallbackWithTracing(SuccessCallback<T> successCallback, Deque<Span> spanStackToLink, Map<String, String> mdcContextMapToLink) {
        return new SuccessCallbackWithTracing<T>(successCallback, spanStackToLink, mdcContextMapToLink);
    }

    public static FailureCallback failureCallbackWithTracing(FailureCallback failureCallback) {
        return new FailureCallbackWithTracing(failureCallback);
    }

    public static FailureCallback failureCallbackWithTracing(FailureCallback failureCallback, Pair<Deque<Span>, Map<String, String>> threadInfoToLink) {
        return new FailureCallbackWithTracing(failureCallback, threadInfoToLink);
    }

    public static FailureCallback failureCallbackWithTracing(FailureCallback failureCallback, Deque<Span> spanStackToLink, Map<String, String> mdcContextMapToLink) {
        return new FailureCallbackWithTracing(failureCallback, spanStackToLink, mdcContextMapToLink);
    }

    public static <T> ListenableFutureCallback<T> listenableFutureCallbackWithTracing(ListenableFutureCallback<T> listenableFutureCallback) {
        return new ListenableFutureCallbackWithTracing<T>(listenableFutureCallback);
    }

    public static <T> ListenableFutureCallback<T> listenableFutureCallbackWithTracing(ListenableFutureCallback<T> listenableFutureCallback, Pair<Deque<Span>, Map<String, String>> threadInfoToLink) {
        return new ListenableFutureCallbackWithTracing<T>(listenableFutureCallback, threadInfoToLink);
    }

    public static <T> ListenableFutureCallback<T> listenableFutureCallbackWithTracing(ListenableFutureCallback<T> listenableFutureCallback, Deque<Span> spanStackToLink, Map<String, String> mdcContextMapToLink) {
        return new ListenableFutureCallbackWithTracing<T>(listenableFutureCallback, spanStackToLink, mdcContextMapToLink);
    }
}

