/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.spring.util.asynchelperwrapper;

import com.nike.internal.util.Pair;
import com.nike.wingtips.Span;
import com.nike.wingtips.Tracer;
import com.nike.wingtips.util.AsyncWingtipsHelperJava7;
import com.nike.wingtips.util.TracingState;
import java.util.Deque;
import java.util.Map;
import org.slf4j.MDC;
import org.springframework.util.concurrent.FailureCallback;

public class FailureCallbackWithTracing
implements FailureCallback {
    protected final FailureCallback origFailureCallback;
    protected final Deque<Span> spanStackForExecution;
    protected final Map<String, String> mdcContextMapForExecution;

    public FailureCallbackWithTracing(FailureCallback origFailureCallback) {
        this(origFailureCallback, Tracer.getInstance().getCurrentSpanStackCopy(), MDC.getCopyOfContextMap());
    }

    public FailureCallbackWithTracing(FailureCallback origFailureCallback, Pair<Deque<Span>, Map<String, String>> originalThreadInfo) {
        this(origFailureCallback, originalThreadInfo == null ? null : (Deque)originalThreadInfo.getLeft(), originalThreadInfo == null ? null : (Map)originalThreadInfo.getRight());
    }

    public FailureCallbackWithTracing(FailureCallback origFailureCallback, Deque<Span> spanStackForExecution, Map<String, String> mdcContextMapForExecution) {
        if (origFailureCallback == null) {
            throw new IllegalArgumentException("origFailureCallback cannot be null");
        }
        this.origFailureCallback = origFailureCallback;
        this.spanStackForExecution = spanStackForExecution;
        this.mdcContextMapForExecution = mdcContextMapForExecution;
    }

    public static FailureCallbackWithTracing withTracing(FailureCallback origFailureCallback) {
        return new FailureCallbackWithTracing(origFailureCallback);
    }

    public static FailureCallbackWithTracing withTracing(FailureCallback origFailureCallback, Pair<Deque<Span>, Map<String, String>> originalThreadInfo) {
        return new FailureCallbackWithTracing(origFailureCallback, originalThreadInfo);
    }

    public static FailureCallbackWithTracing withTracing(FailureCallback origFailureCallback, Deque<Span> spanStackForExecution, Map<String, String> mdcContextMapForExecution) {
        return new FailureCallbackWithTracing(origFailureCallback, spanStackForExecution, mdcContextMapForExecution);
    }

    public void onFailure(Throwable ex) {
        TracingState originalThreadInfo = null;
        try {
            originalThreadInfo = AsyncWingtipsHelperJava7.linkTracingToCurrentThread(this.spanStackForExecution, this.mdcContextMapForExecution);
            this.origFailureCallback.onFailure(ex);
        }
        catch (Throwable throwable) {
            AsyncWingtipsHelperJava7.unlinkTracingFromCurrentThread(originalThreadInfo);
            throw throwable;
        }
        AsyncWingtipsHelperJava7.unlinkTracingFromCurrentThread((Pair)originalThreadInfo);
    }
}

