/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.spring.util.asynchelperwrapper;

import com.nike.internal.util.Pair;
import com.nike.wingtips.Span;
import com.nike.wingtips.Tracer;
import com.nike.wingtips.util.AsyncWingtipsHelperJava7;
import com.nike.wingtips.util.TracingState;
import java.util.Deque;
import java.util.Map;
import org.slf4j.MDC;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class ListenableFutureCallbackWithTracing<T>
implements ListenableFutureCallback<T> {
    protected final ListenableFutureCallback<T> origListenableFutureCallback;
    protected final Deque<Span> spanStackForExecution;
    protected final Map<String, String> mdcContextMapForExecution;

    public ListenableFutureCallbackWithTracing(ListenableFutureCallback<T> origListenableFutureCallback) {
        this(origListenableFutureCallback, Tracer.getInstance().getCurrentSpanStackCopy(), MDC.getCopyOfContextMap());
    }

    public ListenableFutureCallbackWithTracing(ListenableFutureCallback<T> origListenableFutureCallback, Pair<Deque<Span>, Map<String, String>> originalThreadInfo) {
        this(origListenableFutureCallback, originalThreadInfo == null ? null : (Deque)originalThreadInfo.getLeft(), originalThreadInfo == null ? null : (Map)originalThreadInfo.getRight());
    }

    public ListenableFutureCallbackWithTracing(ListenableFutureCallback<T> origListenableFutureCallback, Deque<Span> spanStackForExecution, Map<String, String> mdcContextMapForExecution) {
        if (origListenableFutureCallback == null) {
            throw new IllegalArgumentException("origListenableFutureCallback cannot be null");
        }
        this.origListenableFutureCallback = origListenableFutureCallback;
        this.spanStackForExecution = spanStackForExecution;
        this.mdcContextMapForExecution = mdcContextMapForExecution;
    }

    public static <T> ListenableFutureCallbackWithTracing<T> withTracing(ListenableFutureCallback<T> origListenableFutureCallback) {
        return new ListenableFutureCallbackWithTracing<T>(origListenableFutureCallback);
    }

    public static <T> ListenableFutureCallbackWithTracing<T> withTracing(ListenableFutureCallback<T> origListenableFutureCallback, Pair<Deque<Span>, Map<String, String>> originalThreadInfo) {
        return new ListenableFutureCallbackWithTracing<T>(origListenableFutureCallback, originalThreadInfo);
    }

    public static <T> ListenableFutureCallbackWithTracing<T> withTracing(ListenableFutureCallback<T> origListenableFutureCallback, Deque<Span> spanStackForExecution, Map<String, String> mdcContextMapForExecution) {
        return new ListenableFutureCallbackWithTracing<T>(origListenableFutureCallback, spanStackForExecution, mdcContextMapForExecution);
    }

    public void onSuccess(T result) {
        TracingState originalThreadInfo = null;
        try {
            originalThreadInfo = AsyncWingtipsHelperJava7.linkTracingToCurrentThread(this.spanStackForExecution, this.mdcContextMapForExecution);
            this.origListenableFutureCallback.onSuccess(result);
        }
        catch (Throwable throwable) {
            AsyncWingtipsHelperJava7.unlinkTracingFromCurrentThread(originalThreadInfo);
            throw throwable;
        }
        AsyncWingtipsHelperJava7.unlinkTracingFromCurrentThread((Pair)originalThreadInfo);
    }

    public void onFailure(Throwable ex) {
        TracingState originalThreadInfo = null;
        try {
            originalThreadInfo = AsyncWingtipsHelperJava7.linkTracingToCurrentThread(this.spanStackForExecution, this.mdcContextMapForExecution);
            this.origListenableFutureCallback.onFailure(ex);
        }
        catch (Throwable throwable) {
            AsyncWingtipsHelperJava7.unlinkTracingFromCurrentThread(originalThreadInfo);
            throw throwable;
        }
        AsyncWingtipsHelperJava7.unlinkTracingFromCurrentThread((Pair)originalThreadInfo);
    }
}

