/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.spring.util.asynchelperwrapper;

import com.nike.internal.util.Pair;
import com.nike.wingtips.Span;
import com.nike.wingtips.Tracer;
import com.nike.wingtips.util.AsyncWingtipsHelperJava7;
import com.nike.wingtips.util.TracingState;
import java.util.Deque;
import java.util.Map;
import org.slf4j.MDC;
import org.springframework.util.concurrent.SuccessCallback;

public class SuccessCallbackWithTracing<T>
implements SuccessCallback<T> {
    protected final SuccessCallback<T> origSuccessCallback;
    protected final Deque<Span> spanStackForExecution;
    protected final Map<String, String> mdcContextMapForExecution;

    public SuccessCallbackWithTracing(SuccessCallback<T> origSuccessCallback) {
        this(origSuccessCallback, Tracer.getInstance().getCurrentSpanStackCopy(), MDC.getCopyOfContextMap());
    }

    public SuccessCallbackWithTracing(SuccessCallback<T> origSuccessCallback, Pair<Deque<Span>, Map<String, String>> originalThreadInfo) {
        this(origSuccessCallback, originalThreadInfo == null ? null : (Deque)originalThreadInfo.getLeft(), originalThreadInfo == null ? null : (Map)originalThreadInfo.getRight());
    }

    public SuccessCallbackWithTracing(SuccessCallback<T> origSuccessCallback, Deque<Span> spanStackForExecution, Map<String, String> mdcContextMapForExecution) {
        if (origSuccessCallback == null) {
            throw new IllegalArgumentException("origSuccessCallback cannot be null");
        }
        this.origSuccessCallback = origSuccessCallback;
        this.spanStackForExecution = spanStackForExecution;
        this.mdcContextMapForExecution = mdcContextMapForExecution;
    }

    public static <T> SuccessCallbackWithTracing<T> withTracing(SuccessCallback<T> origSuccessCallback) {
        return new SuccessCallbackWithTracing<T>(origSuccessCallback);
    }

    public static <T> SuccessCallbackWithTracing<T> withTracing(SuccessCallback<T> origSuccessCallback, Pair<Deque<Span>, Map<String, String>> originalThreadInfo) {
        return new SuccessCallbackWithTracing<T>(origSuccessCallback, originalThreadInfo);
    }

    public static <T> SuccessCallbackWithTracing<T> withTracing(SuccessCallback<T> origSuccessCallback, Deque<Span> spanStackForExecution, Map<String, String> mdcContextMapForExecution) {
        return new SuccessCallbackWithTracing<T>(origSuccessCallback, spanStackForExecution, mdcContextMapForExecution);
    }

    public void onSuccess(T result) {
        TracingState originalThreadInfo = null;
        try {
            originalThreadInfo = AsyncWingtipsHelperJava7.linkTracingToCurrentThread(this.spanStackForExecution, this.mdcContextMapForExecution);
            this.origSuccessCallback.onSuccess(result);
        }
        catch (Throwable throwable) {
            AsyncWingtipsHelperJava7.unlinkTracingFromCurrentThread(originalThreadInfo);
            throw throwable;
        }
        AsyncWingtipsHelperJava7.unlinkTracingFromCurrentThread((Pair)originalThreadInfo);
    }
}

