/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.jwksetgen;

import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.openid.connect.provider.jwksetgen.KeyIDs;
import com.thetransactioncompany.json.pretty.PrettyJson;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class JWKSetGenerator {
    protected static RSAKey generateSigningRSAKey(String kid) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(2048);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        return new RSAKey.Builder(rsaPublicKey).privateKey(rsaPrivateKey).keyID(kid).keyUse(KeyUse.SIGNATURE).build();
    }

    protected static ECKey generateSigningECKey(ECKey.Curve crv, String kid) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("EC");
        keyPairGen.initialize(crv.toECParameterSpec());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        ECPublicKey ecPublicKey = (ECPublicKey)keyPair.getPublic();
        ECPrivateKey ecPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        return new ECKey.Builder(crv, ecPublicKey).privateKey(ecPrivateKey).keyID(kid).keyUse(KeyUse.SIGNATURE).build();
    }

    protected static OctetSequenceKey generateEncryptionAESKey(String kid) throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(256);
        SecretKey aesKey = keyGen.generateKey();
        return new OctetSequenceKey.Builder(aesKey).keyID(kid).keyUse(KeyUse.ENCRYPTION).build();
    }

    protected static OctetSequenceKey generateHMACSHA256Key() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("HmacSha256");
        SecretKey hmacKey = keyGen.generateKey();
        return new OctetSequenceKey.Builder(hmacKey).keyID("hmac").keyUse(KeyUse.SIGNATURE).build();
    }

    protected static OctetSequenceKey generateSubjectEncryptionKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(256);
        SecretKey aesKey = keyGen.generateKey();
        return new OctetSequenceKey.Builder(aesKey).keyID("subject-encrypt").keyUse(KeyUse.ENCRYPTION).build();
    }

    public List<JWK> generateRotatingKeys(KeyIDs reservedKeyIDs, boolean withMessage) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        KeyIDs keyIDs = new KeyIDs();
        keyIDs.addAll(reservedKeyIDs);
        RSAKey rsaKey = JWKSetGenerator.generateSigningRSAKey(keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)rsaKey);
        if (withMessage) {
            System.out.println("[1] Generated new signing RSA key with ID " + rsaKey.getKeyID());
        }
        ECKey ecKey = JWKSetGenerator.generateSigningECKey(ECKey.Curve.P_256, keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)ecKey);
        if (withMessage) {
            System.out.println("[2] Generated new signing EC " + ecKey.getCurve() + " key with ID " + ecKey.getKeyID());
        }
        ecKey = JWKSetGenerator.generateSigningECKey(ECKey.Curve.P_384, keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)ecKey);
        if (withMessage) {
            System.out.println("[3] Generated new signing EC " + ecKey.getCurve() + " key with ID " + ecKey.getKeyID());
        }
        ecKey = JWKSetGenerator.generateSigningECKey(ECKey.Curve.P_521, keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)ecKey);
        if (withMessage) {
            System.out.println("[4] Generated new signing EC " + ecKey.getCurve() + " key with ID " + ecKey.getKeyID());
        }
        OctetSequenceKey secretKey = JWKSetGenerator.generateEncryptionAESKey(keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)secretKey);
        if (withMessage) {
            System.out.println("[5] Generated new encryption AES key with ID " + secretKey.getKeyID());
        }
        return keys;
    }

    public List<JWK> generatePermanentKeys(boolean withMessage) throws NoSuchAlgorithmException {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        OctetSequenceKey hmacKey = JWKSetGenerator.generateHMACSHA256Key();
        keys.add((JWK)hmacKey);
        if (withMessage) {
            System.out.println("[6] Generated new HMAC SHA key with ID " + hmacKey.getKeyID());
        }
        OctetSequenceKey subjectKey = JWKSetGenerator.generateSubjectEncryptionKey();
        keys.add((JWK)subjectKey);
        if (withMessage) {
            System.out.println("[7] Generated new pairwise subject AES SIV encryption key with ID " + subjectKey.getKeyID());
        }
        return keys;
    }

    public JWKSet generate(boolean withMessage) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        keys.addAll(this.generateRotatingKeys(new KeyIDs(), withMessage));
        keys.addAll(this.generatePermanentKeys(withMessage));
        return new JWKSet(keys);
    }

    public JWKSet generateAndPrefixNewKeys(JWKSet oldJWKSet, boolean withMessage) throws Exception {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        keys.addAll(this.generateRotatingKeys(new KeyIDs(oldJWKSet), withMessage));
        keys.addAll(oldJWKSet.getKeys());
        if (withMessage) {
            System.out.println("[6] Prefixed newly generated keys to existing JWK set");
        }
        return new JWKSet(keys);
    }

    public static void main(String[] args) {
        JWKSet newJWKSet;
        File newJWKSetFile;
        File oldJWKSetFile;
        System.out.println("JWK set generator for Connect2id server v6.x+");
        if (args.length == 2) {
            oldJWKSetFile = new File(args[0]);
            newJWKSetFile = new File(args[1]);
        } else if (args.length == 1) {
            oldJWKSetFile = null;
            newJWKSetFile = new File(args[0]);
        } else {
            System.out.println("Usage:");
            System.out.println("1) To generate new Connect2id server JWK set: ");
            System.out.println("   java -jar jwkset-gen.jar jwkSet.json");
            System.out.println("2) To add new set of rotating keys to existing Connect2id server JWK set: ");
            System.out.println("   java -jar jwkset-gen.jar oldJWKSet.json newJWKSet.json");
            return;
        }
        JWKSet oldJWKSet = null;
        if (oldJWKSetFile != null) {
            try {
                oldJWKSet = JWKSet.load((File)oldJWKSetFile);
            }
            catch (IOException | ParseException e) {
                System.err.println("Couldn't read old JWK set file: " + e.getMessage());
                return;
            }
        }
        boolean withMessage = true;
        try {
            newJWKSet = oldJWKSet == null ? new JWKSetGenerator().generate(true) : new JWKSetGenerator().generateAndPrefixNewKeys(oldJWKSet, true);
        }
        catch (Exception e) {
            System.err.println("Couldn't generate JWK key: " + e.getMessage());
            return;
        }
        try {
            String json = new PrettyJson(PrettyJson.Style.COMPACT).parseAndFormat(newJWKSet.toJSONObject(false).toJSONString());
            PrintWriter writer = new PrintWriter(newJWKSetFile, "UTF-8");
            writer.write(json);
            writer.write("\n");
            writer.close();
        }
        catch (IOException | ParseException e) {
            System.err.println("Couldn't write new JWK set file: " + e.getMessage());
        }
    }
}

