/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.jwksetgen;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jose.jwk.gen.OctetKeyPairGenerator;
import com.nimbusds.jose.jwk.gen.OctetSequenceKeyGenerator;
import com.nimbusds.jose.jwk.gen.RSAKeyGenerator;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.openid.connect.provider.jwksetgen.KeyIDs;
import com.thetransactioncompany.json.pretty.PrettyJson;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class JWKSetGenerator {
    public static final int RSA_KEY_BIT_SIZE = 2048;
    public static final int AES_KEY_BIT_SIZE = 128;
    public static final int HMAC_SHA_KEY_BIT_SIZE = 256;
    public static final int SUBJECT_AES_SIV_KEY_BIT_SIZE = 256;
    public static final int REFRESH_TOKEN_AES_SIV_KEY_BIT_SIZE = 256;

    public static RSAKey generateSigningRSAKey(String kid) throws JOSEException {
        return (RSAKey)new RSAKeyGenerator(2048).keyID(kid).keyUse(KeyUse.SIGNATURE).generate();
    }

    public static RSAKey generateEncryptionRSAKey(String kid) throws JOSEException {
        return (RSAKey)new RSAKeyGenerator(2048).keyID(kid).keyUse(KeyUse.ENCRYPTION).generate();
    }

    public static ECKey generateSigningECKey(Curve crv, String kid) throws JOSEException {
        return (ECKey)new ECKeyGenerator(crv).keyID(kid).keyUse(KeyUse.SIGNATURE).generate();
    }

    public static ECKey generateEncryptionECKey(Curve crv, String kid) throws JOSEException {
        return (ECKey)new ECKeyGenerator(crv).keyID(kid).keyUse(KeyUse.ENCRYPTION).generate();
    }

    public static OctetKeyPair generateSigningEd25519Key(String kid) throws JOSEException {
        return (OctetKeyPair)new OctetKeyPairGenerator(Curve.Ed25519).keyID(kid).keyUse(KeyUse.SIGNATURE).generate();
    }

    public static OctetSequenceKey generateEncryptionAESKey(String kid) throws JOSEException {
        return (OctetSequenceKey)new OctetSequenceKeyGenerator(128).keyID(kid).keyUse(KeyUse.ENCRYPTION).generate();
    }

    public static OctetSequenceKey generateHMACSHA256Key() throws JOSEException {
        return (OctetSequenceKey)new OctetSequenceKeyGenerator(256).keyID("hmac").keyUse(KeyUse.SIGNATURE).generate();
    }

    public static OctetSequenceKey generateSubjectEncryptionKey() throws JOSEException {
        return (OctetSequenceKey)new OctetSequenceKeyGenerator(256).keyID("subject-encrypt").keyUse(KeyUse.ENCRYPTION).generate();
    }

    public static OctetSequenceKey generateRefreshTokenEncryptionKey() throws JOSEException {
        return (OctetSequenceKey)new OctetSequenceKeyGenerator(256).keyID("refresh-token-encrypt").keyUse(KeyUse.ENCRYPTION).generate();
    }

    public List<JWK> generateRotatingKeys(KeyIDs reservedKeyIDs, boolean withMessage) throws JOSEException {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        KeyIDs keyIDs = new KeyIDs();
        keyIDs.addAll(reservedKeyIDs);
        RSAKey rsaKey = JWKSetGenerator.generateSigningRSAKey(keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)rsaKey);
        if (withMessage) {
            System.out.println("[1] Generated new signing RSA 2048 bit key with ID " + rsaKey.getKeyID());
        }
        ECKey ecKey = JWKSetGenerator.generateSigningECKey(Curve.P_256, keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)ecKey);
        if (withMessage) {
            System.out.println("[2] Generated new signing EC " + ecKey.getCurve() + " key with ID " + ecKey.getKeyID());
        }
        ecKey = JWKSetGenerator.generateSigningECKey(Curve.P_384, keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)ecKey);
        if (withMessage) {
            System.out.println("[3] Generated new signing EC " + ecKey.getCurve() + " key with ID " + ecKey.getKeyID());
        }
        ecKey = JWKSetGenerator.generateSigningECKey(Curve.P_521, keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)ecKey);
        if (withMessage) {
            System.out.println("[4] Generated new signing EC " + ecKey.getCurve() + " key with ID " + ecKey.getKeyID());
        }
        OctetKeyPair okp = JWKSetGenerator.generateSigningEd25519Key(keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)okp);
        if (withMessage) {
            System.out.println("[5] Generated new signing " + okp.getCurve() + " key with ID " + okp.getKeyID());
        }
        rsaKey = JWKSetGenerator.generateEncryptionRSAKey(keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)rsaKey);
        if (withMessage) {
            System.out.println("[6] Generated new encryption RSA 2048 bit key with ID " + rsaKey.getKeyID());
        }
        ecKey = JWKSetGenerator.generateEncryptionECKey(Curve.P_256, keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)ecKey);
        if (withMessage) {
            System.out.println("[7] Generated new encryption EC " + ecKey.getCurve() + " key with ID " + ecKey.getKeyID());
        }
        ecKey = JWKSetGenerator.generateEncryptionECKey(Curve.P_384, keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)ecKey);
        if (withMessage) {
            System.out.println("[8] Generated new encryption EC " + ecKey.getCurve() + " key with ID " + ecKey.getKeyID());
        }
        ecKey = JWKSetGenerator.generateEncryptionECKey(Curve.P_521, keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)ecKey);
        if (withMessage) {
            System.out.println("[9] Generated new encryption EC " + ecKey.getCurve() + " key with ID " + ecKey.getKeyID());
        }
        OctetSequenceKey secretKey = JWKSetGenerator.generateEncryptionAESKey(keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)secretKey);
        if (withMessage) {
            System.out.println("[10] Generated new encryption AES 128 bit key with ID " + secretKey.getKeyID());
        }
        return keys;
    }

    public List<JWK> generatePermanentKeys(boolean withMessage) throws JOSEException {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        OctetSequenceKey hmacKey = JWKSetGenerator.generateHMACSHA256Key();
        keys.add((JWK)hmacKey);
        if (withMessage) {
            System.out.println("[11] Generated new HMAC SHA 256 bit key with ID " + hmacKey.getKeyID());
        }
        OctetSequenceKey subjectKey = JWKSetGenerator.generateSubjectEncryptionKey();
        keys.add((JWK)subjectKey);
        if (withMessage) {
            System.out.println("[12] Generated new subject encryption AES SIV 256 bit key with ID " + subjectKey.getKeyID());
        }
        OctetSequenceKey refreshTokenKey = JWKSetGenerator.generateRefreshTokenEncryptionKey();
        keys.add((JWK)refreshTokenKey);
        if (withMessage) {
            System.out.println("[13] Generated new refresh token encryption AES SIV 256 bit key with ID " + refreshTokenKey.getKeyID());
        }
        return keys;
    }

    public JWKSet generate(boolean withMessage) throws JOSEException {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        keys.addAll(this.generateRotatingKeys(new KeyIDs(), withMessage));
        keys.addAll(this.generatePermanentKeys(withMessage));
        return new JWKSet(keys);
    }

    public JWKSet generateAndPrefixNewKeys(JWKSet oldJWKSet, boolean withMessage) throws Exception {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        keys.addAll(this.generateRotatingKeys(new KeyIDs(oldJWKSet), withMessage));
        keys.addAll(oldJWKSet.getKeys());
        if (withMessage) {
            System.out.println("[11] Prefixed newly generated keys to existing JWK set");
        }
        return new JWKSet(keys);
    }

    static void printUsage() {
        System.out.println("Usage:");
        System.out.println("1) Generate new Connect2id server JWK set: ");
        System.out.println("   java -jar jwkset-gen.jar jwkSet.json");
        System.out.println("2) Generate new set of rotating keys and add to existing Connect2id server JWK set: ");
        System.out.println("   java -jar jwkset-gen.jar oldJWKSet.json newJWKSet.json");
        System.out.println("3) BASE64URL encode the output JWK set: ");
        System.out.println("   java -jar -b64 jwkset-gen.jar oldJWKSet.json newJWKSet.json.b64");
    }

    public static void main(String[] args) {
        String output;
        JWKSet newJWKSet;
        File newJWKSetFile;
        File oldJWKSetFile;
        CommandLine commandLine;
        String softwareVersion = JWKSetGenerator.class.getPackage().getImplementationVersion();
        System.out.println("JWK set generator " + (softwareVersion != null ? "v" + softwareVersion + " " : "") + "for Connect2id server v6.x+");
        Options options = new Options();
        options.addOption("b64", false, "BASE64URL encode the output JWK set");
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("Command line parse error: " + e.getMessage());
            JWKSetGenerator.printUsage();
            return;
        }
        boolean b64Encode = commandLine.hasOption("b64");
        List argList = commandLine.getArgList();
        if (argList.size() == 2) {
            oldJWKSetFile = new File((String)argList.get(0));
            newJWKSetFile = new File((String)argList.get(1));
        } else if (argList.size() == 1) {
            oldJWKSetFile = null;
            newJWKSetFile = new File((String)argList.get(0));
        } else {
            JWKSetGenerator.printUsage();
            return;
        }
        JWKSet oldJWKSet = null;
        if (oldJWKSetFile != null) {
            try {
                oldJWKSet = JWKSet.load((File)oldJWKSetFile);
            }
            catch (IOException | java.text.ParseException e) {
                System.err.println("Couldn't read old JWK set file: " + e.getMessage());
                return;
            }
        }
        boolean withMessage = true;
        try {
            newJWKSet = oldJWKSet == null ? new JWKSetGenerator().generate(true) : new JWKSetGenerator().generateAndPrefixNewKeys(oldJWKSet, true);
        }
        catch (Exception e) {
            System.err.println("Couldn't generate JWK key: " + e.getMessage());
            return;
        }
        String json = newJWKSet.toJSONObject(false).toJSONString();
        if (b64Encode) {
            output = Base64URL.encode((String)json).toString();
        } else {
            try {
                output = new PrettyJson(PrettyJson.Style.COMPACT).parseAndFormat(json);
            }
            catch (java.text.ParseException e) {
                System.err.println("Couldn't format JSON: " + e.getMessage());
                return;
            }
        }
        try {
            PrintWriter writer = new PrintWriter(newJWKSetFile, "UTF-8");
            writer.write(output);
            writer.write("\n");
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Couldn't write new JWK set file: " + e.getMessage());
        }
    }
}

