/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.jwksetgen;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.gen.RSAKeyGenerator;
import com.nimbusds.openid.connect.provider.jwksetgen.KeyIDs;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

public class FederationJWKSetGenerator {
    public static final int RSA_KEY_BIT_SIZE = 2048;

    public static RSAKey generateSigningRSAKey(String kid) throws JOSEException {
        return (RSAKey)new RSAKeyGenerator(2048).keyID(kid).algorithm((Algorithm)JWSAlgorithm.RS256).keyUse(KeyUse.SIGNATURE).generate();
    }

    public List<JWK> generateRotatingKeys(KeyIDs reservedKeyIDs, Consumer<String> eventMessageSink) throws JOSEException {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        KeyIDs keyIDs = new KeyIDs();
        keyIDs.addAll(reservedKeyIDs);
        RSAKey rsaKey = FederationJWKSetGenerator.generateSigningRSAKey(keyIDs.addRandomUniqueKeyID());
        keys.add((JWK)rsaKey);
        if (eventMessageSink != null) {
            eventMessageSink.accept("Generated new signing RSA 2048 bit key with ID " + rsaKey.getKeyID());
        }
        return keys;
    }

    public JWKSet generate(Consumer<String> eventMessageSink) throws JOSEException {
        return new JWKSet(this.generateRotatingKeys(new KeyIDs(), eventMessageSink));
    }

    public JWKSet generateAndPrefixNewKeys(JWKSet oldJWKSet, Consumer<String> eventMessageSink) throws Exception {
        LinkedList<JWK> keys = new LinkedList<JWK>(this.generateRotatingKeys(new KeyIDs(oldJWKSet), eventMessageSink));
        keys.addAll(oldJWKSet.getKeys());
        if (eventMessageSink != null) {
            eventMessageSink.accept("Prefixed newly generated keys to existing federation entity JWK set");
        }
        return new JWKSet(keys);
    }
}

