/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.config;

import com.nimbusds.common.config.LoggableConfiguration;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomKeyStoreConfiguration
implements LoggableConfiguration {
    public final boolean enable;
    public final String file;
    public final String type;
    public final String password;
    private final Logger log = LogManager.getLogger((String)"MAIN");

    public CustomKeyStoreConfiguration(String prefix, Properties props) throws PropertyParseException {
        PropertyRetriever pr = new PropertyRetriever(props);
        this.enable = pr.getOptBoolean(prefix + "enable", false);
        if (this.enable) {
            this.file = pr.getString(prefix + "file");
            this.type = pr.getOptString(prefix + "type", null);
            this.password = pr.getOptString(prefix + "password", null);
        } else {
            this.file = null;
            this.type = null;
            this.password = null;
        }
    }

    @Override
    public void log() {
        this.log.info("[CM1210] Custom key store enabled: {}", new Object[]{this.enable});
        if (this.enable) {
            this.log.info("[CM1211] Custom key store file: {}", new Object[]{this.file});
            this.log.info("[CM1212] Custom key store type: {}", new Object[]{this.type});
        }
    }
}

