/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.config;

import com.nimbusds.common.config.LDAPServerDetails;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LDAPServerConnectionPoolDetails
extends LDAPServerDetails {
    public final int connectionPoolSize;
    public static final int DEFAULT_CONNECTION_POOL_SIZE = 5;
    public final int connectionPoolInitialSize;
    public static final int DEFAULT_CONNECTION_POOL_INITIAL_SIZE = 0;
    public final int connectionPoolMaxWaitTime;
    public static final int DEFAULT_CONNECTION_POOL_MAX_WAIT_TIME = 500;
    public final long connectionMaxAge;
    public static final int DEFAULT_CONNECTION_MAX_AGE = 0;

    public LDAPServerConnectionPoolDetails(String prefix, Properties props) throws PropertyParseException {
        this(prefix, props, true);
    }

    public LDAPServerConnectionPoolDetails(String prefix, Properties props, boolean requireURL) throws PropertyParseException {
        super(prefix, props, requireURL);
        PropertyRetriever pr = new PropertyRetriever(props);
        this.connectionPoolSize = pr.getOptInt(prefix + "connectionPoolSize", 5);
        this.connectionPoolInitialSize = pr.getOptInt(prefix + "connectionPoolInitialSize", 0);
        if (this.connectionPoolInitialSize > this.connectionPoolSize) {
            throw new PropertyParseException("The LDAP server connection pool initial size must not exceed the max size", prefix + "connectionPoolInitialSize", this.connectionPoolInitialSize + "");
        }
        this.connectionPoolMaxWaitTime = pr.getOptInt(prefix + "connectionPoolMaxWaitTime", 500);
        this.connectionMaxAge = pr.getOptLong(prefix + "connectionMaxAge", 0L);
    }

    @Override
    public void log() {
        super.log();
        if (this.url == null) {
            return;
        }
        Logger log = LogManager.getLogger((String)"MAIN");
        log.info("[CM1100] LDAP server connection pool size: {}", new Object[]{this.connectionPoolSize});
        log.info("[CM1103] LDAP server connection pool initial size: {}", new Object[]{this.connectionPoolInitialSize});
        log.info("[CM1101] LDAP server connection pool max wait time: {} ms", new Object[]{this.connectionPoolMaxWaitTime});
        log.info("[CM1102] LDAP server connection pool max age: {} ms", new Object[]{this.connectionMaxAge});
    }
}

