/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.codahale.metrics.health.HealthCheck;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import org.apache.logging.log4j.Logger;

public class LDAPHealthCheck
extends HealthCheck {
    private final LDAPInterface ldap;
    private final DN testEntry;
    private final Logger log;

    public LDAPHealthCheck(LDAPInterface ldap, DN testEntry, Logger log) {
        if (ldap == null) {
            throw new IllegalArgumentException("The LDAP interface must not be null");
        }
        this.ldap = ldap;
        if (testEntry == null) {
            throw new IllegalArgumentException("The LDAP test entry must not be null");
        }
        this.testEntry = testEntry;
        this.log = log;
    }

    public HealthCheck.Result check() throws Exception {
        SearchResultEntry entry;
        try {
            entry = this.ldap.getEntry(this.testEntry.toString());
        }
        catch (LDAPException e) {
            if (this.log != null) {
                this.log.warn("LDAP connector health check failure: {}", new Object[]{e.getMessage()});
            }
            return HealthCheck.Result.unhealthy((String)e.getMessage());
        }
        if (entry == null) {
            String msg = "LDAP connector health check failure: Missing test entry: " + this.testEntry;
            if (this.log != null) {
                this.log.warn(msg);
            }
            return HealthCheck.Result.unhealthy((String)msg);
        }
        if (this.log != null) {
            this.log.debug("LDAP connector health check success: healthy");
        }
        return HealthCheck.Result.healthy();
    }
}

