/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.id;

import com.nimbusds.common.id.BaseIdentifier;
import com.nimbusds.common.id.InvalidIdentifierException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class IdentifierWithHMAC
extends BaseIdentifier {
    public static final int DEFAULT_BYTE_LENGTH = 16;

    private static byte[] computeHMAC(byte[] message, SecretKey hmacKey) {
        Mac hmacComputer;
        try {
            hmacComputer = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        SecretKeySpec secret_key = new SecretKeySpec(hmacKey.getEncoded(), "HmacSHA256");
        try {
            hmacComputer.init(secret_key);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return hmacComputer.doFinal(message);
    }

    private static String generate(SecretKey hmacKey) {
        byte[] n = new byte[16];
        SECURE_RANDOM.nextBytes(n);
        byte[] hmac = IdentifierWithHMAC.computeHMAC(n, hmacKey);
        return Base64.encodeBase64URLSafeString((byte[])n) + "." + Base64.encodeBase64URLSafeString((byte[])hmac);
    }

    public IdentifierWithHMAC(SecretKey hmacKey) {
        super(IdentifierWithHMAC.generate(hmacKey));
    }

    private IdentifierWithHMAC(String value) {
        super(value);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof IdentifierWithHMAC && this.toString().equals(object.toString());
    }

    public static IdentifierWithHMAC parseAndValidate(String value, SecretKey hmacKey) throws InvalidIdentifierException {
        String[] parts = value.split("\\.");
        if (parts.length != 2) {
            throw new InvalidIdentifierException("Illegal identifier with HMAC format");
        }
        if (parts[0].trim().isEmpty()) {
            throw new InvalidIdentifierException("Missing identifier value");
        }
        if (parts[1].trim().isEmpty()) {
            throw new InvalidIdentifierException("Missing HMAC for the identifier value");
        }
        byte[] n = Base64.decodeBase64((String)parts[0]);
        byte[] hmac = Base64.decodeBase64((String)parts[1]);
        byte[] expectedHMAC = IdentifierWithHMAC.computeHMAC(n, hmacKey);
        if (!MessageDigest.isEqual(expectedHMAC, hmac)) {
            throw new InvalidIdentifierException("Invalid HMAC");
        }
        return new IdentifierWithHMAC(value);
    }
}

