/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import java.util.HashMap;
import java.util.Map;

public class LDAPConnectionPoolMetrics
implements MetricSet {
    private final Map<String, Metric> metricMap = new HashMap<String, Metric>();

    public LDAPConnectionPoolMetrics(final LDAPConnectionPool pool, String prefix) {
        this.metricMap.put(prefix + ".maxAvailableConnections", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return pool.getConnectionPoolStatistics().getMaximumAvailableConnections();
            }
        });
        this.metricMap.put(prefix + ".numAvailableConnections", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return pool.getConnectionPoolStatistics().getNumAvailableConnections();
            }
        });
        this.metricMap.put(prefix + ".numConnectionsClosedDefunct", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return pool.getConnectionPoolStatistics().getNumConnectionsClosedDefunct();
            }
        });
        this.metricMap.put(prefix + ".numConnectionsClosedExpired", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return pool.getConnectionPoolStatistics().getNumConnectionsClosedExpired();
            }
        });
        this.metricMap.put(prefix + ".numConnectionsClosedUnneeded", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return pool.getConnectionPoolStatistics().getNumConnectionsClosedUnneeded();
            }
        });
        this.metricMap.put(prefix + ".numFailedCheckouts", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return pool.getConnectionPoolStatistics().getNumFailedCheckouts();
            }
        });
        this.metricMap.put(prefix + ".numFailedConnectionAttempts", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return pool.getConnectionPoolStatistics().getNumFailedConnectionAttempts();
            }
        });
        this.metricMap.put(prefix + ".numReleasedValid", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return pool.getConnectionPoolStatistics().getNumReleasedValid();
            }
        });
        this.metricMap.put(prefix + ".numSuccessfulCheckouts", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return pool.getConnectionPoolStatistics().getNumSuccessfulCheckouts();
            }
        });
        this.metricMap.put(prefix + ".numSuccessfulCheckoutsNewConnection", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return pool.getConnectionPoolStatistics().getNumSuccessfulCheckoutsNewConnection();
            }
        });
        this.metricMap.put(prefix + ".numSuccessfulCheckoutsWithoutWaiting", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return pool.getConnectionPoolStatistics().getNumSuccessfulCheckoutsWithoutWaiting();
            }
        });
        this.metricMap.put(prefix + ".numSuccessfulCheckoutsAfterWaiting", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return pool.getConnectionPoolStatistics().getNumSuccessfulCheckoutsAfterWaiting();
            }
        });
        this.metricMap.put(prefix + ".numSuccessfulConnectionAttempts", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return pool.getConnectionPoolStatistics().getNumSuccessfulConnectionAttempts();
            }
        });
    }

    public Map<String, Metric> getMetrics() {
        return this.metricMap;
    }
}

