/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.nimbusds.common.servlet.ResourceRetriever;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExampleDirectory
implements ServletContextListener {
    private InMemoryDirectoryServer ds = null;
    private ServletContext servletContext;
    private final Logger log = LogManager.getLogger((String)"MAIN");

    private String getFullPath(String filename) {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return filename;
        }
        return this.servletContext.getRealPath(File.separator) + filename;
    }

    public void start(Configuration config) throws LDAPException, IOException, LDIFException {
        if (!config.enable) {
            this.log.info("Example directory server: disabled");
            return;
        }
        InMemoryListenerConfig listenerConfig = InMemoryListenerConfig.createLDAPConfig((String)"example-ds", (int)config.port);
        Schema schema = null;
        if (config.schema != null) {
            String schemaFullPath = this.getFullPath(config.schema);
            schema = Schema.getSchema((String[])new String[]{schemaFullPath});
            this.log.info("Example directory server: Schema LDIF file: {}", (Object)schemaFullPath);
        }
        InMemoryDirectoryServerConfig dsConfig = new InMemoryDirectoryServerConfig(new String[]{config.baseDN});
        this.log.info("Example directory server: Base DN: {}", (Object)config.baseDN);
        dsConfig.setSchema(schema);
        dsConfig.setListenerConfigs(new InMemoryListenerConfig[]{listenerConfig});
        dsConfig.setAllowedOperationTypes(new OperationType[]{OperationType.BIND, OperationType.COMPARE, OperationType.SEARCH, OperationType.EXTENDED});
        this.ds = new InMemoryDirectoryServer(dsConfig);
        if (config.content != null) {
            String contentFullPath = this.getFullPath(config.content);
            this.ds.importFromLDIF(true, contentFullPath);
            this.log.info("Example directory server: Populated from LDIF file {}", (Object)contentFullPath);
        }
        this.ds.startListening();
        this.log.info("Example directory server: Started on port {}", (Object)this.ds.getListenPort());
    }

    public void stop() {
        if (this.ds == null) {
            return;
        }
        this.ds.shutDown(true);
        this.log.info("Example directory server: Shut down");
    }

    public void contextInitialized(ServletContextEvent sce) {
        Configuration config;
        this.servletContext = sce.getServletContext();
        try {
            Properties props = ResourceRetriever.getProperties(this.servletContext, "exampleDirectory.configurationFile", this.log);
            config = new Configuration(props);
        }
        catch (Exception e) {
            this.log.error("Couldn't configure example directory server: {}", (Object)e.getMessage());
            return;
        }
        try {
            this.start(config);
        }
        catch (LDAPException e) {
            this.log.error("Couldn't start example directory server: {}", (Object)e.getMessage());
        }
        catch (LDIFException | IOException e) {
            this.log.error("Couldn't read schema file: {}", (Object)e.getMessage());
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.stop();
    }

    public static class Configuration {
        public final boolean enable;
        public static final boolean DEFAULT_ENABLE = false;
        public final int port;
        public static final int DEFAULT_PORT = 10389;
        public final String schema;
        public final String baseDN;
        public final String content;

        public Configuration(Properties props) throws PropertyParseException {
            PropertyRetriever pr = new PropertyRetriever(props);
            this.enable = pr.getOptBoolean("exampleDirectoryServer.enable", false);
            if (!this.enable) {
                this.port = 10389;
                this.schema = null;
                this.baseDN = null;
                this.content = null;
                return;
            }
            this.port = pr.getOptInt("exampleDirectoryServer.port", 10389);
            String s = pr.getOptString("exampleDirectoryServer.schema", null);
            this.schema = s == null || s.isEmpty() ? null : s;
            this.baseDN = pr.getString("exampleDirectoryServer.baseDN");
            s = pr.getOptString("exampleDirectoryServer.content", null);
            this.content = s == null || s.isEmpty() ? null : s;
        }
    }
}

