package com.nimbusds.common.servlet;


import java.io.InputStream;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;


/**
 * Configures Log4j logging at servlet context startup. 
 *
 * <p>The name / path of the Log4j properties file is specified in a servlet 
 * context init parameter {@code log4j.configurationFile}.
 *
 * @author Vladimir Dzhuvinov
 */
public class Log4jConfigurator implements ServletContextListener {
	
	
	/**
	 * Handler for servlet context startup events; configures Log4j using
	 * the properties file specified in the servlet context parameter
	 * {@code log4j.configurationFile}. 
	 *
	 * <p>The properties file location must be relative to the web 
	 * application directory, e.g. {@code /WEB-INF/log4j.properties}.
	 *
	 * <p>Upon successful Log4j initialisation logs the event at INFO 
	 * level.
	 *
	 * @param sce A servlet context event.
	 */
	@Override
	public void contextInitialized(ServletContextEvent sce) {

		ServletContext servletContext = sce.getServletContext();

		String configFile = servletContext.getInitParameter("log4j.configurationFile");
		
		if (configFile == null || configFile.trim().isEmpty())
			return; // Logging disabled
		
		InputStream is = servletContext.getResourceAsStream(configFile);
		
		if (is == null)
			return;
		
		PropertyConfigurator.configure(is);
			
		Logger logger = LogManager.getLogger(Log4jConfigurator.class);
		logger.info("Configured Log4j from properties file " + configFile);
	}


	/**
	 * Handler for servlet context shutdown events.
	 *
	 * @param sce A servlet context event.
	 */
	@Override
	public void contextDestroyed(ServletContextEvent sce) {

		// Do nothing
	}
}
