/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.jsonrpc2;

import com.thetransactioncompany.jsonrpc2.JSONRPC2ParamsType;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import java.util.Map;
import org.apache.log4j.Logger;

public class JSONRPC2LogUtility {
    private static final Logger log = Logger.getLogger(JSONRPC2LogUtility.class);

    public static void log(JSONRPC2Request request, JSONRPC2Response response, String prefix) {
        if (!log.isInfoEnabled()) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        if (prefix != null) {
            msg.append("[" + prefix + "] ");
        }
        msg.append(request.getMethod());
        msg.append(": ");
        if (response.indicatesSuccess()) {
            msg.append("Success");
        } else {
            msg.append("Error " + response.getError().getCode() + ": " + response.getError().getMessage());
        }
        log.info((Object)msg.toString());
    }

    public static void log(JSONRPC2Request request, JSONRPC2Response response) {
        JSONRPC2LogUtility.log(request, response, null);
    }

    public static JSONRPC2Request hideParameter(JSONRPC2Request request, String paramName) {
        if (request == null) {
            return null;
        }
        if (request.getParamsType() != JSONRPC2ParamsType.OBJECT) {
            return request;
        }
        Map params = request.getNamedParams();
        if (params.containsKey(paramName)) {
            params.put(paramName, "[hidden]");
        }
        return request;
    }

    public static JSONRPC2Request hidePassword(JSONRPC2Request request) {
        return JSONRPC2LogUtility.hideParameter(request, "password");
    }

    private JSONRPC2LogUtility() {
    }
}

