/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagUtil;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.util.StaticUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;

public class AttributeMapper {
    private Map<String, Directive> transformMap;
    private final String[] ldapAttributes;

    public AttributeMapper(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("The attribute transformation map must not be null");
        }
        try {
            this.transformMap = Directive.parseDirectives(map);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("The attribute transformation map is invalid: " + e.getMessage(), e);
        }
        this.ldapAttributes = new String[this.transformMap.size()];
        int i = 0;
        for (Directive dir : this.transformMap.values()) {
            this.ldapAttributes[i++] = dir.ldapAttributeName();
        }
    }

    public String[] getLDAPAttributeNames() {
        return this.ldapAttributes;
    }

    public List<String> getLDAPAttributeNames(List<String> jsonObjectKey) {
        ArrayList<String> list = new ArrayList<String>(jsonObjectKey.size());
        for (String key : jsonObjectKey) {
            String ldapAttrName = this.getLDAPAttributeName(key);
            if (ldapAttrName == null) continue;
            list.add(ldapAttrName);
        }
        return Collections.unmodifiableList(list);
    }

    public String getLDAPAttributeName(String targetName) {
        Directive dir = this.transformMap.get(targetName);
        if (dir == null) {
            return null;
        }
        return dir.ldapAttributeName();
    }

    public JSONObject transform(Entry ldapEntry) {
        JSONObject out = new JSONObject();
        for (Map.Entry<String, Directive> mapping : this.transformMap.entrySet()) {
            try {
                Directive dir = mapping.getValue();
                if (!ldapEntry.hasAttribute(dir.ldapAttributeName()) && !dir.langTagged()) continue;
                Object jsonValue = null;
                if (dir.jsonValueType().equals("string")) {
                    if (dir.langTagged()) {
                        for (Attribute a : ldapEntry.getAttributesWithOptions(dir.ldapAttributeName(), null)) {
                            LangTag langTag = null;
                            for (String opt : a.getOptions()) {
                                if (!opt.startsWith("lang-")) continue;
                                langTag = LangTag.parse((String)opt.substring("lang-".length()));
                            }
                            if (langTag != null) {
                                out.put((Object)(mapping.getKey() + "#" + langTag.toString()), (Object)a.getValue());
                                continue;
                            }
                            out.put((Object)mapping.getKey(), (Object)a.getValue());
                        }
                    } else {
                        jsonValue = ldapEntry.getAttributeValue(dir.ldapAttributeName());
                    }
                } else if (dir.jsonValueType().equals("string-array")) {
                    String[] array = ldapEntry.getAttributeValues(dir.ldapAttributeName());
                    if (array != null) {
                        jsonValue = Arrays.asList(array);
                    }
                } else if (dir.jsonValueType().equals("boolean")) {
                    jsonValue = ldapEntry.getAttributeValueAsBoolean(dir.ldapAttributeName());
                } else if (dir.jsonValueType().equals("int")) {
                    jsonValue = ldapEntry.getAttributeValueAsInteger(dir.ldapAttributeName());
                } else if (dir.jsonValueType().equals("long")) {
                    if (dir.ldapAttributeType().equals("time")) {
                        String t = ldapEntry.getAttributeValue(dir.ldapAttributeName());
                        jsonValue = StaticUtils.decodeGeneralizedTime((String)t).getTime() / 1000L;
                    } else {
                        jsonValue = ldapEntry.getAttributeValueAsLong(dir.ldapAttributeName());
                    }
                }
                if (jsonValue == null) continue;
                out.put((Object)mapping.getKey(), jsonValue);
            }
            catch (Exception e) {}
        }
        return out;
    }

    public JSONObject transform(Map<String, Object> in) {
        JSONObject out = new JSONObject();
        for (Map.Entry<String, Directive> mapping : this.transformMap.entrySet()) {
            try {
                Directive dir = mapping.getValue();
                List valuesIn = (List)in.get(dir.ldapAttributeName());
                if (valuesIn == null) continue;
                Object jsonValue = null;
                if (dir.jsonValueType().equals("string")) {
                    jsonValue = (String)valuesIn.get(0);
                } else if (dir.jsonValueType().equals("string-array")) {
                    jsonValue = valuesIn;
                } else if (dir.jsonValueType().equals("boolean")) {
                    jsonValue = Boolean.parseBoolean((String)valuesIn.get(0));
                } else if (dir.jsonValueType().equals("int")) {
                    jsonValue = Integer.parseInt((String)valuesIn.get(0));
                } else if (dir.jsonValueType().equals("long")) {
                    if (dir.ldapAttributeType().equals("time")) {
                        String t = (String)valuesIn.get(0);
                        jsonValue = StaticUtils.decodeGeneralizedTime((String)t).getTime() / 1000L;
                    } else {
                        jsonValue = Long.parseLong((String)valuesIn.get(0));
                    }
                }
                if (jsonValue == null) continue;
                out.put((Object)mapping.getKey(), jsonValue);
            }
            catch (Exception e) {}
        }
        return out;
    }

    public List<Attribute> reverseTransform(JSONObject jsonObject) {
        ArrayList<Attribute> ldapAttrs = new ArrayList<Attribute>(jsonObject.size());
        for (Map.Entry<String, Directive> mapping : this.transformMap.entrySet()) {
            try {
                Directive dir = mapping.getValue();
                if (dir.langTagged() && dir.jsonValueType().equals("string") && dir.ldapAttributeType().equals("string")) {
                    Map langTaggedEntries = LangTagUtil.find((String)mapping.getKey(), (Map)jsonObject);
                    for (Map.Entry entry : langTaggedEntries.entrySet()) {
                        if (entry.getValue() == null) continue;
                        String ldapAttributeName = dir.ldapAttributeName();
                        LangTag langTag = (LangTag)entry.getKey();
                        if (langTag != null) {
                            ldapAttributeName = ldapAttributeName + ";lang-" + langTag.toString();
                        }
                        ldapAttrs.add(new Attribute(ldapAttributeName, entry.getValue().toString()));
                    }
                    continue;
                }
                Object jsonValue = jsonObject.get((Object)mapping.getKey());
                if (jsonValue instanceof List) {
                    List jsonValues = (List)jsonValue;
                    ArrayList<String> ldapValues = new ArrayList<String>();
                    for (Object v : jsonValues) {
                        if (v instanceof Long && dir.jsonValueType().equals("long") && dir.jsonValueType().equals("time")) {
                            long t = (Long)jsonValue;
                            ldapValues.add(StaticUtils.encodeGeneralizedTime((Date)new Date(t * 1000L)));
                            continue;
                        }
                        ldapValues.add(v.toString());
                    }
                    ldapAttrs.add(new Attribute(dir.ldapAttributeName(), ldapValues));
                    continue;
                }
                if (jsonValue instanceof Long && dir.jsonValueType().equals("long") && dir.ldapAttributeType().equals("time")) {
                    long t = (Long)jsonValue;
                    ldapAttrs.add(new Attribute(dir.ldapAttributeName(), StaticUtils.encodeGeneralizedTime((Date)new Date(t * 1000L))));
                    continue;
                }
                ldapAttrs.add(new Attribute(dir.ldapAttributeName(), jsonValue.toString()));
            }
            catch (Exception e) {}
        }
        return ldapAttrs;
    }

    private static final class Directive {
        private final String jsonType;
        private final String ldapAttr;
        private final String ldapType;
        private final boolean langTagged;

        public Directive(String ldapAttr, String ldapType, String jsonType, boolean langTagged) {
            if (ldapAttr == null) {
                throw new IllegalArgumentException("Missing LDAP attribute name");
            }
            this.ldapAttr = ldapAttr;
            this.ldapType = ldapType == null ? "string" : ldapType;
            this.jsonType = jsonType == null ? "string" : jsonType;
            this.langTagged = langTagged;
        }

        public String ldapAttributeName() {
            return this.ldapAttr;
        }

        public String ldapAttributeType() {
            return this.ldapType;
        }

        public String jsonValueType() {
            return this.jsonType;
        }

        public boolean langTagged() {
            return this.langTagged;
        }

        public static Directive parse(Map<String, Object> map) throws ParseException {
            String ldapAttrName = null;
            try {
                ldapAttrName = (String)map.get("ldapAttr");
            }
            catch (Exception e) {
                throw new ParseException("Invalid LDAP attribute name", 0);
            }
            if (ldapAttrName == null) {
                throw new ParseException("Missing LDAP attribute name", 0);
            }
            String ldapAttrType = null;
            if (map.containsKey("ldapType")) {
                try {
                    ldapAttrType = (String)map.get("ldapType");
                }
                catch (Exception e) {
                    throw new ParseException("Invalid LDAP attribute type", 0);
                }
            }
            if (ldapAttrType == null) {
                ldapAttrType = "string";
            }
            if (!ldapAttrType.equals("string") && !ldapAttrType.equals("time")) {
                throw new ParseException("Invalid attribute LDAP type, must be \"string\" or \"time\"", 0);
            }
            String jsonType = null;
            if (map.containsKey("jsonType")) {
                try {
                    jsonType = (String)map.get("jsonType");
                }
                catch (Exception e) {
                    throw new ParseException("Invalid JSON value type", 0);
                }
            }
            if (jsonType == null) {
                jsonType = "string";
            }
            if (!(jsonType.equals("string") || jsonType.equals("string-array") || jsonType.equals("int") || jsonType.equals("long") || jsonType.equals("boolean"))) {
                throw new ParseException("Invalid JSON value type, must be \"string\", \"string-array\", \"int\", \"long\" or \"boolean\"", 0);
            }
            boolean langTagged = false;
            if (map.containsKey("langTag")) {
                try {
                    langTagged = (Boolean)map.get("langTag");
                }
                catch (Exception e) {
                    throw new ParseException("Invalid language tag option, must be boolean true or false", 0);
                }
            }
            return new Directive(ldapAttrName, ldapAttrType, jsonType, langTagged);
        }

        public static Map<String, Directive> parseDirectives(Map<String, Object> map) throws ParseException {
            HashMap<String, Directive> directives = new HashMap<String, Directive>();
            for (Map.Entry<String, Object> mapping : map.entrySet()) {
                Directive dir;
                String jsonObjectMemberName = mapping.getKey();
                if (mapping.getValue() == null) {
                    throw new ParseException("Missing mapping directive for \"" + jsonObjectMemberName + "\"", 0);
                }
                try {
                    Map dirMap = (Map)mapping.getValue();
                    dir = Directive.parse(dirMap);
                }
                catch (Exception e) {
                    throw new ParseException("Invalid mapping directive for \"" + jsonObjectMemberName + "\": " + e.getMessage(), 0);
                }
                directives.put(jsonObjectMemberName, dir);
            }
            return directives;
        }
    }
}

