/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.nimbusds.common.ldap.LDAPControlResultFormatter;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class LDIFResultFormatter {
    public static String formatEntry(Entry entry) {
        return entry.toLDIFString();
    }

    public static Map<String, Object> formatSearchResult(SearchResult sr) {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        StringBuilder buffer = new StringBuilder();
        for (SearchResultEntry entry : sr.getSearchEntries()) {
            entry.toLDIFString(buffer);
            buffer.append("\n");
        }
        jsonObject.put("matches", buffer.toString());
        LinkedList<String> referrals = new LinkedList<String>();
        for (SearchResultReference ref : sr.getSearchReferences()) {
            for (String url : ref.getReferralURLs()) {
                referrals.add(url);
            }
        }
        jsonObject.put("referrals", referrals);
        LDAPControlResultFormatter.appendSearchControlResults(jsonObject, sr);
        return jsonObject;
    }

    private LDIFResultFormatter() {
    }
}

