/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ServletLogUtility {
    private static final Logger log = Logger.getLogger(ServletLogUtility.class);

    public static void log(HttpServletRequest httpRequest) {
        X509Certificate[] certs;
        if (!log.isInfoEnabled()) {
            return;
        }
        String hostIp = httpRequest.getRemoteAddr();
        String method = httpRequest.getMethod();
        String corsOrigin = String.valueOf(httpRequest.getAttribute("cors.origin"));
        StringBuilder msg = new StringBuilder("HTTP");
        if (httpRequest.isSecure()) {
            msg.append("S");
        }
        if (!corsOrigin.equals("null")) {
            msg.append(" CORS ");
        } else {
            msg.append(" ");
        }
        msg.append(method + " request from " + hostIp);
        if (!corsOrigin.equals("null")) {
            msg.append(" origin: " + corsOrigin);
        }
        if ((certs = (X509Certificate[])httpRequest.getAttribute("javax.servlet.request.X509Certificate")) != null) {
            for (int i = 0; i < certs.length; ++i) {
                X500Principal principal = certs[i].getSubjectX500Principal();
                if (principal == null) continue;
                String principalName = principal.getName();
                msg.append(" principal[" + i + "]: " + principalName);
            }
        }
        log.info((Object)msg.toString());
    }

    private ServletLogUtility() {
    }
}

