/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.config;

import com.nimbusds.common.config.LoggableConfiguration;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DirectoryUser
implements LoggableConfiguration {
    public final DN dn;
    public final String password;

    public DirectoryUser(String prefix, Properties props) throws PropertyParseException {
        PropertyRetriever pr = new PropertyRetriever(props);
        String dnString = pr.getString(prefix + "dn");
        if (dnString.isEmpty()) {
            this.dn = DN.NULL_DN;
        } else {
            try {
                this.dn = new DN(dnString);
            }
            catch (LDAPException e) {
                throw new PropertyParseException("Invalid DN", prefix + "dn", dnString);
            }
        }
        this.password = pr.getString(prefix + "password");
    }

    public DirectoryUser(DN dn, String password) {
        if (dn == null) {
            throw new IllegalArgumentException("The directory user DN must not be null");
        }
        this.dn = dn;
        if (password == null) {
            throw new IllegalArgumentException("The directory user password must not be null");
        }
        this.password = password;
    }

    @Override
    public void log() {
        Logger log = Logger.getLogger(LoggableConfiguration.class);
        if (this.dn.equals((Object)DN.NULL_DN)) {
            log.info((Object)"Directory user DN: [anonymous]");
        } else {
            log.info((Object)("Directory user DN: " + this.dn.toString()));
        }
    }
}

