/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.config;

import com.nimbusds.common.config.WebServiceDetails;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Json2LdapDetails
extends WebServiceDetails {
    public final boolean useDefaultLDAPServer;
    public static final boolean DEFAULT_LDAP_SERVER = true;

    public Json2LdapDetails(String prefix, Properties props) throws PropertyParseException {
        super(prefix, props);
        PropertyRetriever pr = new PropertyRetriever(props);
        this.useDefaultLDAPServer = pr.getOptBoolean(prefix + "useDefaultLDAPServer", true);
    }

    @Override
    public void log() {
        Logger log = Logger.getLogger(Json2LdapDetails.class);
        log.info((Object)("Json2Ldap URL: " + this.url));
        if (this.url.getProtocol().equalsIgnoreCase("http")) {
            log.warn((Object)"Json2Ldap connection is not protected (plain HTTP), consider using SSL (HTTPS)");
        }
        log.info((Object)("Json2Ldap with default LDAP server: " + this.useDefaultLDAPServer));
        if (this.url.getProtocol().equalsIgnoreCase("https")) {
            log.info((Object)("Self-signed Json2Ldap certificates are trusted: " + this.trustSelfSignedCerts));
        }
        if (this.connectTimeout > 0) {
            log.info((Object)("Json2Ldap HTTP connect timeout: " + this.connectTimeout + "us"));
        } else {
            log.info((Object)"Json2Ldap HTTP connect timeout: disabled");
        }
        if (this.readTimeout > 0) {
            log.info((Object)("Json2Ldap HTTP read timeout: " + this.readTimeout + "us"));
        } else {
            log.info((Object)"Json2Ldap HTTP read timeout: disabled");
        }
        if (this.apiKey != null) {
            log.info((Object)"Json2Ldap API key: provided");
        } else {
            log.info((Object)"Json2Ldap API key: not provided");
        }
    }
}

