/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.util.NamedParamsRetriever;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AttributesForRetrieval {
    private String[] spec = null;
    private Set<String> allNames = new HashSet<String>();
    private Set<String> binaryNames = new HashSet<String>();

    public Set<String> getBinaryAttributes() {
        return this.binaryNames;
    }

    public String[] getSpec() {
        return this.spec;
    }

    public static String[] parseValues(String paramName, NamedParamsRetriever params) throws JSONRPC2Error {
        if (!params.hasParam(paramName)) {
            return new String[0];
        }
        Object v = params.get(paramName);
        if (v instanceof String) {
            String vString = ((String)v).trim();
            if (!vString.isEmpty()) {
                return vString.split("[\\s,]");
            }
            return new String[0];
        }
        if (v instanceof List) {
            List vList = (List)v;
            if (!vList.isEmpty()) {
                return params.getStringArray(paramName);
            }
            return new String[0];
        }
        throw JSONRPC2Error.INVALID_PARAMS;
    }

    public void parse(NamedParamsRetriever params) throws JSONRPC2Error {
        this.spec = null;
        if (params.hasParam("attributes")) {
            String[] names;
            for (String name : names = AttributesForRetrieval.parseValues("attributes", params)) {
                if (name.equals("*+") || name.equals("+*")) {
                    this.allNames.add("*");
                    this.allNames.add("+");
                    continue;
                }
                this.allNames.add(name.toLowerCase());
            }
        }
        if (params.hasParam("binaryAttributes")) {
            for (String name : AttributesForRetrieval.parseValues("binaryAttributes", params)) {
                if (name.equals("*") || name.equals("1.1") || name.equals("+")) continue;
                this.allNames.add(name.toLowerCase());
                this.binaryNames.add(name.toLowerCase());
            }
        }
        if (this.allNames.size() > 0) {
            this.spec = this.allNames.toArray(new String[0]);
        } else if (params.hasParam("attributes") && this.allNames.isEmpty()) {
            this.spec = new String[]{"1.1"};
        }
    }
}

