/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;

public class FilterTemplate {
    private final String template;
    private final String placeholder;

    public FilterTemplate(String template, String placeholder) {
        if (template == null) {
            throw new IllegalArgumentException("The template must not be null");
        }
        this.template = template;
        if (placeholder == null) {
            throw new IllegalArgumentException("The placeholder must not be null");
        }
        this.placeholder = placeholder;
        if (template.indexOf(placeholder) == -1) {
            throw new IllegalArgumentException("Filter template must contain one or more placeholders");
        }
        String testParam = "user001";
        String filter = template.replaceAll(placeholder, testParam);
        try {
            Filter.create((String)filter);
        }
        catch (LDAPException e) {
            throw new IllegalArgumentException("Invalid filter template: " + e.getMessage(), e);
        }
    }

    public FilterTemplate(String template) {
        this(template, "%u");
    }

    public String getTemplate() {
        return this.template;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public String apply(String param) {
        String sanitizedParam = Filter.encodeValue((String)param);
        return this.template.replaceAll(this.placeholder, sanitizedParam);
    }

    public String toString() {
        return this.getTemplate();
    }
}

