/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.oauth2;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class BasicAccessTokenValidator {
    private final BearerAccessToken accessToken;
    public static final WebApplicationException MISSING_BEARER_TOKEN;
    public static final WebApplicationException INVALID_BEARER_TOKEN;
    public static final WebApplicationException WEB_API_DISABLED;

    public BasicAccessTokenValidator(BearerAccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public BearerAccessToken getAccessToken() {
        return this.accessToken;
    }

    public void validateBearerAccessToken(String authzHeader) throws WebApplicationException {
        BearerAccessToken token;
        if (StringUtils.isBlank((CharSequence)authzHeader)) {
            throw MISSING_BEARER_TOKEN;
        }
        try {
            token = BearerAccessToken.parse((String)authzHeader);
        }
        catch (ParseException e) {
            throw MISSING_BEARER_TOKEN;
        }
        if (this.accessToken == null) {
            throw WEB_API_DISABLED;
        }
        if (!token.equals((Object)this.accessToken)) {
            throw INVALID_BEARER_TOKEN;
        }
    }

    static {
        JSONObject o = new JSONObject();
        o.put((Object)"error", (Object)"Unauthorized: Missing Bearer access token");
        MISSING_BEARER_TOKEN = new WebApplicationException(Response.status((int)BearerTokenError.MISSING_TOKEN.getHTTPStatusCode()).header("WWW-Authenticate", (Object)BearerTokenError.MISSING_TOKEN.toWWWAuthenticateHeader()).entity((Object)o.toJSONString()).type("application/json").build());
        o = new JSONObject();
        o.put((Object)"error", (Object)"Unauthorized: Invalid Bearer access token");
        INVALID_BEARER_TOKEN = new WebApplicationException(Response.status((int)BearerTokenError.INVALID_TOKEN.getHTTPStatusCode()).header("WWW-Authenticate", (Object)BearerTokenError.INVALID_TOKEN.toWWWAuthenticateHeader()).entity((Object)o.toJSONString()).type("application/json").build());
        o = new JSONObject();
        o.put((Object)"error", (Object)"Forbidden: Web API disabled");
        WEB_API_DISABLED = new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)o.toJSONString()).type("application/json").build());
    }
}

