/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;

public class InfinispanLauncher
implements ServletContextListener {
    public static final String INFINISPAN_CONFIG_FILENAME = "infinispan.configurationFile";
    public static final String INFINISPAN_CTX_ATTRIBUTE_NAME = "org.infinispan.manager.EmbeddedCacheManager";
    private EmbeddedCacheManager cacheManager;

    public void contextInitialized(ServletContextEvent sce) throws IllegalArgumentException {
        Logger log = Logger.getLogger(InfinispanLauncher.class);
        ServletContext servletContext = sce.getServletContext();
        String configFile = servletContext.getInitParameter(INFINISPAN_CONFIG_FILENAME);
        if (configFile == null || configFile.trim().isEmpty()) {
            log.error((Object)"Couldn't load Infinispan configuration: Missing servlet context parameter \"infinispan.configurationFile\"");
            return;
        }
        InputStream is = servletContext.getResourceAsStream(configFile);
        if (is == null) {
            log.error((Object)("Couldn't load Infinispan configuration file: " + configFile));
            return;
        }
        try {
            this.cacheManager = new DefaultCacheManager(is);
        }
        catch (IOException e) {
            log.error((Object)("Couldn't start Infinispan cache manager: " + e.getMessage()));
            return;
        }
        servletContext.setAttribute(INFINISPAN_CTX_ATTRIBUTE_NAME, (Object)this.cacheManager);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.cacheManager == null) {
            return;
        }
        this.cacheManager.stop();
    }
}

