/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.nimbusds.common.config.CustomKeyStoreConfiguration;
import com.nimbusds.common.config.CustomTrustStoreConfiguration;
import com.nimbusds.common.ldap.LDAPConnectionException;
import com.nimbusds.common.ldap.LDAPConnectionSecurity;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;

public class LDAPConnectionFactory {
    private final CustomTrustStoreConfiguration customTrustStore;
    private final CustomKeyStoreConfiguration customKeyStore;

    public LDAPConnectionFactory(CustomTrustStoreConfiguration customTrustStore, CustomKeyStoreConfiguration customKeyStore) throws LDAPConnectionException {
        if (customTrustStore == null) {
            throw new IllegalArgumentException("The custom TLS/SSL trust store configuration must not be null");
        }
        this.customTrustStore = customTrustStore;
        if (customKeyStore == null) {
            throw new IllegalArgumentException("The custom TLS/SSL key store configuration must not be null");
        }
        this.customKeyStore = customKeyStore;
    }

    public CustomTrustStoreConfiguration getCustomTrustStoreConfiguration() {
        return this.customTrustStore;
    }

    public CustomKeyStoreConfiguration getCustomKeyStoreConfiguration() {
        return this.customKeyStore;
    }

    public static SSLUtil initSecureConnectionContext(CustomTrustStoreConfiguration customTrustStore, CustomKeyStoreConfiguration customKeyStore, boolean trustSelfSignedCerts) throws KeyStoreException {
        boolean examineValidityDates;
        TrustAllTrustManager trustManager = null;
        if (trustSelfSignedCerts) {
            examineValidityDates = true;
            trustManager = new TrustAllTrustManager(examineValidityDates);
        } else if (customTrustStore.enable) {
            examineValidityDates = true;
            trustManager = new TrustStoreTrustManager(customTrustStore.file, customTrustStore.password.toCharArray(), customTrustStore.type, examineValidityDates);
        } else {
            trustManager = null;
        }
        KeyStoreKeyManager keyManager = null;
        if (customKeyStore.enable) {
            String certificateAlias = null;
            keyManager = new KeyStoreKeyManager(customKeyStore.file, customKeyStore.password.toCharArray(), customKeyStore.type, certificateAlias);
        } else {
            keyManager = null;
        }
        return new SSLUtil(keyManager, (TrustManager)trustManager);
    }

    public static SocketFactory getSocketFactory(LDAPConnectionSecurity security, CustomTrustStoreConfiguration customTrustStore, CustomKeyStoreConfiguration customKeyStore, boolean trustSelfSignedCerts) throws LDAPConnectionException {
        if (security != LDAPConnectionSecurity.SSL) {
            return null;
        }
        try {
            SSLUtil sslUtil = LDAPConnectionFactory.initSecureConnectionContext(customTrustStore, customKeyStore, trustSelfSignedCerts);
            return sslUtil.createSSLSocketFactory();
        }
        catch (KeyStoreException e) {
            throw new LDAPConnectionException("Key store exception: " + e.getMessage(), LDAPConnectionException.CauseType.KEYSTORE_ERROR, e);
        }
        catch (GeneralSecurityException e) {
            throw new LDAPConnectionException("Couldn't create SSL socket factory: " + e.getMessage(), LDAPConnectionException.CauseType.TLS_SSL_ERROR, e);
        }
    }

    private void applyStartTLS(LDAPConnection con, boolean trustSelfSignedCerts) throws LDAPConnectionException {
        SSLUtil sslUtil = null;
        try {
            sslUtil = LDAPConnectionFactory.initSecureConnectionContext(this.customTrustStore, this.customKeyStore, trustSelfSignedCerts);
        }
        catch (KeyStoreException e) {
            throw new LDAPConnectionException("Key store exception: " + e.getMessage(), LDAPConnectionException.CauseType.KEYSTORE_ERROR, e);
        }
        SSLContext sslContext = null;
        try {
            sslContext = sslUtil.createSSLContext();
        }
        catch (GeneralSecurityException e) {
            throw new LDAPConnectionException("TLS/SSL error: " + e.getMessage(), LDAPConnectionException.CauseType.TLS_SSL_ERROR, e);
        }
        ExtendedResult extResult = null;
        try {
            StartTLSExtendedRequest extRequest = new StartTLSExtendedRequest(sslContext);
            extResult = con.processExtendedOperation((ExtendedRequest)extRequest);
        }
        catch (LDAPException e) {
            con.close();
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof SSLHandshakeException) {
                throw new LDAPConnectionException("Bad server X.509 certificate: " + e.getMessage(), LDAPConnectionException.CauseType.BAD_CERT, e);
            }
            throw LDAPConnectionException.parse(e);
        }
        if (extResult.getResultCode() != ResultCode.SUCCESS) {
            con.close();
            throw new LDAPConnectionException("StartTLS exception: " + extResult.getDiagnosticMessage(), LDAPConnectionException.CauseType.STARTTLS_ERROR, null);
        }
    }

    public LDAPConnection createLDAPConnection(String host, int port, LDAPConnectionSecurity security, int timeout, boolean trustSelfSignedCerts) throws LDAPConnectionException {
        SocketFactory socketFactory = LDAPConnectionFactory.getSocketFactory(security, this.customTrustStore, this.customKeyStore, trustSelfSignedCerts);
        LDAPConnectionOptions opts = new LDAPConnectionOptions();
        opts.setConnectTimeoutMillis(timeout);
        SingleServerSet ldapServerSet = new SingleServerSet(host, port, socketFactory, opts);
        return this.createLDAPConnection((ServerSet)ldapServerSet, security, trustSelfSignedCerts);
    }

    public LDAPConnection createLDAPConnection(ServerSet ldapServerSet, LDAPConnectionSecurity security, boolean trustSelfSignedCerts) throws LDAPConnectionException {
        LDAPConnection con = null;
        try {
            con = ldapServerSet.getConnection();
        }
        catch (LDAPException e) {
            throw LDAPConnectionException.parse(e);
        }
        if (security != LDAPConnectionSecurity.STARTTLS) {
            return con;
        }
        this.applyStartTLS(con, trustSelfSignedCerts);
        return con;
    }
}

