/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.jsonrpc2;

import com.nimbusds.common.jsonrpc2.Banner;
import com.nimbusds.common.jsonrpc2.JSONRPC2LogUtility;
import com.nimbusds.common.jsonrpc2.RequestHandlerWithLifecycle;
import com.nimbusds.common.servlet.ServletLogUtility;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import com.thetransactioncompany.jsonrpc2.server.MessageContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class JSONRPC2Servlet
extends HttpServlet {
    protected RequestHandlerWithLifecycle service;
    protected String wsName;
    protected String wsVersion;
    protected Banner banner;
    protected String responseContentType;
    private final Logger log = Logger.getLogger(JSONRPC2Servlet.class);

    public void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException {
        ServletLogUtility.log(httpRequest);
        MessageContext requestContext = new MessageContext(httpRequest);
        httpResponse.setHeader("X-Web-Service", this.wsName);
        httpResponse.setContentType(this.responseContentType);
        PrintWriter out = null;
        try {
            out = httpResponse.getWriter();
        }
        catch (IOException e) {
            this.log.error((Object)("HTTP POST I/O exception: " + e.getMessage()), (Throwable)e);
            throw new ServletException("HTTP POST I/O exception: " + e.getMessage(), (Throwable)e);
        }
        StringBuilder postContent = new StringBuilder(256);
        try {
            BufferedReader reader = httpRequest.getReader();
            String line = null;
            while ((line = reader.readLine()) != null) {
                postContent.append(line);
                postContent.append(System.getProperty("line.separator"));
            }
            reader.close();
        }
        catch (IOException e) {
            this.log.error((Object)("HTTP POST I/O exception: " + e.getMessage()), (Throwable)e);
            throw new ServletException("HTTP POST I/O exception: " + e.getMessage(), (Throwable)e);
        }
        JSONRPC2Request request = null;
        try {
            request = JSONRPC2Request.parse((String)postContent.toString());
        }
        catch (JSONRPC2ParseException e) {
            this.log.info((Object)("Invalid JSON-RPC 2.0 request: " + e.getMessage()));
            out.println(new JSONRPC2Response(JSONRPC2Error.PARSE_ERROR, null));
            return;
        }
        JSONRPC2Response response = this.service.process(request, requestContext);
        out.println(response);
        out.close();
        JSONRPC2LogUtility.log(request, response);
    }

    public void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException {
        ServletLogUtility.log(httpRequest);
        httpResponse.setHeader("X-Web-Service", this.wsName);
        httpResponse.setContentType("text/plain; charset=utf-8");
        try {
            this.banner.apply(httpResponse);
        }
        catch (IOException e) {
            this.log.error((Object)"HTTP GET I/O exception", (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
        this.log.info((Object)("Stopping " + this.wsName + "..."));
        try {
            this.service.stop();
        }
        catch (Exception e) {
            this.log.warn((Object)(this.wsName + " stop exception: " + e.getMessage()), (Throwable)e);
        }
    }
}

