/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagUtils;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.util.StaticUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minidev.json.JSONObject;

public class AttributeMapper {
    public static final Pattern SPLIT_PATTERN = Pattern.compile(" ");
    private final Map<Key, Directive> transformMap;
    private final String[] ldapAttributes;

    private static Map<Key, Directive> parseDirectives(Map<String, Object> map) throws ParseException {
        HashMap<Key, Directive> directives = new HashMap<Key, Directive>();
        for (Map.Entry<String, Object> mapping : map.entrySet()) {
            Directive dir;
            Key key = new Key(mapping.getKey());
            if (mapping.getValue() == null) {
                throw new ParseException("Missing mapping directive for \"" + key + "\"", 0);
            }
            try {
                Map dirMap = (Map)mapping.getValue();
                dir = Directive.parse(dirMap);
            }
            catch (Exception e) {
                throw new ParseException("Invalid mapping directive for \"" + key + "\": " + e.getMessage(), 0);
            }
            directives.put(key, dir);
        }
        return directives;
    }

    public AttributeMapper(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("The attribute transformation map must not be null");
        }
        try {
            this.transformMap = AttributeMapper.parseDirectives(map);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("The attribute transformation map is invalid: " + e.getMessage(), e);
        }
        ArrayList<String> ldapAttributeNames = new ArrayList<String>();
        for (Directive dir : this.transformMap.values()) {
            String ldapAttrName = dir.ldapAttributeName();
            if (ldapAttrName == null) continue;
            ldapAttributeNames.add(ldapAttrName);
        }
        this.ldapAttributes = ldapAttributeNames.toArray(new String[ldapAttributeNames.size()]);
    }

    public String[] getLDAPAttributeNames() {
        return this.ldapAttributes;
    }

    public List<String> getLDAPAttributeNames(List<String> keys) {
        ArrayList<String> list = new ArrayList<String>(keys.size());
        for (String k : keys) {
            String ldapAttrName = this.getLDAPAttributeName(k);
            if (ldapAttrName == null) continue;
            list.add(ldapAttrName);
        }
        return Collections.unmodifiableList(list);
    }

    public String getLDAPAttributeName(String key) {
        Directive dir = this.transformMap.get(new Key(key));
        if (dir == null) {
            return null;
        }
        return dir.ldapAttributeName();
    }

    private static void putMember(JSONObject jsonObject, Key key, Object value, LangTag langTag, Pattern reMatcher) {
        if (value == null) {
            return;
        }
        ArrayList<String> valueToPut = value;
        if (reMatcher != null) {
            if (value instanceof String) {
                Matcher matcher = reMatcher.matcher((String)((Object)value));
                if (!matcher.matches()) {
                    return;
                }
                valueToPut = matcher.group(1);
            } else if (value instanceof List) {
                List valueList = value;
                ArrayList<String> processedList = new ArrayList<String>(valueList.size());
                for (String v : valueList) {
                    Matcher matcher = reMatcher.matcher(v);
                    if (!matcher.matches()) continue;
                    processedList.add(matcher.group(1));
                }
                if (processedList.isEmpty()) {
                    return;
                }
                valueToPut = processedList;
            }
        }
        if (!key.isNested()) {
            if (langTag != null) {
                jsonObject.put((Object)(key + "#" + langTag), (Object)valueToPut);
            } else {
                jsonObject.put((Object)key.value(), (Object)valueToPut);
            }
        } else {
            JSONObject childJSONObject;
            String parentKey = key.parts()[0];
            if (langTag != null) {
                parentKey = parentKey + "#" + langTag;
            }
            if ((childJSONObject = (JSONObject)jsonObject.get((Object)parentKey)) == null) {
                childJSONObject = new JSONObject();
            }
            childJSONObject.put((Object)key.parts()[1], (Object)valueToPut);
            jsonObject.put((Object)parentKey, (Object)childJSONObject);
        }
    }

    public JSONObject transform(Entry ldapEntry) {
        JSONObject out = new JSONObject();
        for (Map.Entry<Key, Directive> mapping : this.transformMap.entrySet()) {
            try {
                List<Attribute> attrList;
                Key key = mapping.getKey();
                Directive dir = mapping.getValue();
                if (dir.langTagged()) {
                    attrList = ldapEntry.getAttributesWithOptions(dir.ldapAttributeName(), null);
                    if (attrList.isEmpty()) {
                        continue;
                    }
                } else {
                    attrList = new ArrayList(1);
                    if (dir.ldapAttributeName() != null) {
                        Attribute attr = ldapEntry.getAttribute(dir.ldapAttributeName());
                        if (attr == null) continue;
                        attrList.add(attr);
                    } else {
                        attrList.add(new Attribute("x-name", dir.ldapValue()));
                    }
                }
                if (dir.jsonValueType().equals("string")) {
                    if (dir.langTagged()) {
                        for (Attribute a : attrList) {
                            LangTag langTag = null;
                            for (String opt : a.getOptions()) {
                                if (!opt.startsWith("lang-")) continue;
                                langTag = LangTag.parse((String)opt.substring("lang-".length()));
                                break;
                            }
                            AttributeMapper.putMember(out, key, a.getValue(), langTag, dir.ldapValueMatchingPattern());
                        }
                        continue;
                    }
                    String jsonString = null;
                    if (dir.split()) {
                        StringBuilder sb = new StringBuilder();
                        for (String v : ((Attribute)attrList.get(0)).getValues()) {
                            if (v == null) continue;
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            sb.append(v);
                        }
                        if (sb.length() > 0) {
                            jsonString = sb.toString();
                        }
                    } else {
                        jsonString = ((Attribute)attrList.get(0)).getValue();
                    }
                    AttributeMapper.putMember(out, key, jsonString, null, dir.ldapValueMatchingPattern());
                    continue;
                }
                if (dir.jsonValueType().equals("string-array")) {
                    String[] array = ((Attribute)attrList.get(0)).getValues();
                    if (array == null) continue;
                    AttributeMapper.putMember(out, key, Arrays.asList(array), null, dir.ldapValueMatchingPattern());
                    continue;
                }
                if (dir.jsonValueType().equals("boolean")) {
                    AttributeMapper.putMember(out, key, ((Attribute)attrList.get(0)).getValueAsBoolean(), null, dir.ldapValueMatchingPattern());
                    continue;
                }
                if (dir.jsonValueType().equals("int")) {
                    AttributeMapper.putMember(out, key, ((Attribute)attrList.get(0)).getValueAsInteger(), null, dir.ldapValueMatchingPattern());
                    continue;
                }
                if (!dir.jsonValueType().equals("long")) continue;
                if (dir.ldapAttributeType().equals("time")) {
                    String genTimeStr = ((Attribute)attrList.get(0)).getValue();
                    Long timeStamp = StaticUtils.decodeGeneralizedTime((String)genTimeStr).getTime() / 1000L;
                    AttributeMapper.putMember(out, key, timeStamp, null, dir.ldapValueMatchingPattern());
                    continue;
                }
                AttributeMapper.putMember(out, key, ((Attribute)attrList.get(0)).getValueAsLong(), null, dir.ldapValueMatchingPattern());
            }
            catch (Exception e) {}
        }
        return out;
    }

    public JSONObject transform(Map<String, Object> in) {
        JSONObject out = new JSONObject();
        for (Map.Entry<Key, Directive> mapping : this.transformMap.entrySet()) {
            try {
                List<String> valuesIn;
                Key key = mapping.getKey();
                Directive dir = mapping.getValue();
                if (dir.ldapAttributeName() != null) {
                    valuesIn = (List)in.get(dir.ldapAttributeName());
                } else {
                    valuesIn = new ArrayList(1);
                    valuesIn.add(dir.ldapValue());
                }
                if (valuesIn == null) continue;
                Object jsonValue = null;
                if (dir.jsonValueType().equals("string")) {
                    if (dir.split()) {
                        StringBuilder sb = new StringBuilder();
                        for (Object e : valuesIn) {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            sb.append((String)e);
                        }
                        if (sb.length() > 0) {
                            jsonValue = sb.toString();
                        }
                    } else {
                        jsonValue = valuesIn.get(0);
                    }
                } else if (dir.jsonValueType().equals("string-array")) {
                    jsonValue = valuesIn;
                } else if (dir.jsonValueType().equals("boolean")) {
                    jsonValue = Boolean.parseBoolean((String)valuesIn.get(0));
                } else if (dir.jsonValueType().equals("int")) {
                    jsonValue = Integer.parseInt((String)valuesIn.get(0));
                } else if (dir.jsonValueType().equals("long")) {
                    if (dir.ldapAttributeType().equals("time")) {
                        String t = (String)valuesIn.get(0);
                        jsonValue = StaticUtils.decodeGeneralizedTime((String)t).getTime() / 1000L;
                    } else {
                        jsonValue = Long.parseLong((String)valuesIn.get(0));
                    }
                }
                AttributeMapper.putMember(out, key, jsonValue, null, dir.ldapValueMatchingPattern());
            }
            catch (Exception e) {}
        }
        return out;
    }

    public List<Attribute> reverseTransform(JSONObject jsonObject) {
        ArrayList<Attribute> ldapAttrs = new ArrayList<Attribute>(jsonObject.size());
        for (Map.Entry<Key, Directive> mapping : this.transformMap.entrySet()) {
            try {
                Key key = mapping.getKey();
                Directive dir = mapping.getValue();
                if (dir.ldapValue() != null) continue;
                if (dir.langTagged() && dir.jsonValueType().equals("string") && dir.ldapAttributeType().equals("string")) {
                    Map langTaggedEntries = LangTagUtils.find((String)key.value(), (Map)jsonObject);
                    for (Map.Entry entry : langTaggedEntries.entrySet()) {
                        if (entry.getValue() == null) continue;
                        String ldapAttributeName = dir.ldapAttributeName();
                        LangTag langTag = (LangTag)entry.getKey();
                        if (langTag != null) {
                            ldapAttributeName = ldapAttributeName + ";lang-" + langTag.toString();
                        }
                        ldapAttrs.add(new Attribute(ldapAttributeName, entry.getValue().toString()));
                    }
                    continue;
                }
                Object jsonValue = jsonObject.get((Object)key.value());
                if (jsonValue instanceof String && dir.jsonValueType().equals("string") && dir.ldapAttributeType().equals("string")) {
                    String[] ldapValues = dir.split() ? SPLIT_PATTERN.split((String)jsonValue) : new String[]{(String)jsonValue};
                    ldapAttrs.add(new Attribute(dir.ldapAttributeName(), ldapValues));
                    continue;
                }
                if (jsonValue instanceof List) {
                    List jsonValues = (List)jsonValue;
                    ArrayList<String> ldapValues = new ArrayList<String>();
                    for (Object v : jsonValues) {
                        if (v instanceof Long && dir.jsonValueType().equals("long") && dir.jsonValueType().equals("time")) {
                            long t = (Long)jsonValue;
                            ldapValues.add(StaticUtils.encodeGeneralizedTime((Date)new Date(t * 1000L)));
                            continue;
                        }
                        ldapValues.add(v.toString());
                    }
                    ldapAttrs.add(new Attribute(dir.ldapAttributeName(), ldapValues));
                    continue;
                }
                if (jsonValue instanceof Long && dir.jsonValueType().equals("long") && dir.ldapAttributeType().equals("time")) {
                    long t = (Long)jsonValue;
                    ldapAttrs.add(new Attribute(dir.ldapAttributeName(), StaticUtils.encodeGeneralizedTime((Date)new Date(t * 1000L))));
                    continue;
                }
                ldapAttrs.add(new Attribute(dir.ldapAttributeName(), jsonValue.toString()));
            }
            catch (Exception e) {}
        }
        return ldapAttrs;
    }

    private static final class Directive {
        private final String jsonType;
        private final String ldapAttr;
        private final String ldapValue;
        private final String ldapType;
        private final boolean langTagged;
        private final Pattern matchPattern;
        private final boolean split;

        public Directive(String ldapAttr, String ldapValue, String ldapType, String jsonType, boolean langTagged, Pattern matchPattern, boolean split) {
            if (ldapAttr == null && ldapValue == null) {
                throw new IllegalArgumentException("Missing LDAP attribute name / value");
            }
            if (ldapAttr != null && ldapValue != null) {
                throw new IllegalArgumentException("Either an LDAP attribute name or an LDAP value must be specified, but not both");
            }
            this.ldapAttr = ldapAttr;
            this.ldapValue = ldapValue;
            this.ldapType = ldapType == null ? "string" : ldapType;
            this.jsonType = jsonType == null ? "string" : jsonType;
            this.langTagged = langTagged;
            this.matchPattern = matchPattern;
            this.split = split;
        }

        public String ldapAttributeName() {
            return this.ldapAttr;
        }

        public String ldapValue() {
            return this.ldapValue;
        }

        public String ldapAttributeType() {
            return this.ldapType;
        }

        public String jsonValueType() {
            return this.jsonType;
        }

        public boolean langTagged() {
            return this.langTagged;
        }

        public Pattern ldapValueMatchingPattern() {
            return this.matchPattern;
        }

        public boolean split() {
            return this.split;
        }

        public static Directive parse(Map<String, Object> map) throws ParseException {
            String ldapValue;
            String ldapAttrName;
            try {
                ldapAttrName = (String)map.get("ldapAttr");
            }
            catch (Exception e) {
                throw new ParseException("Invalid LDAP attribute name", 0);
            }
            try {
                ldapValue = (String)map.get("ldapValue");
            }
            catch (Exception e) {
                throw new ParseException("Invalid LDAP value", 0);
            }
            if (ldapAttrName == null && ldapValue == null) {
                throw new ParseException("Missing LDAP attribute name / value", 0);
            }
            if (ldapAttrName != null && ldapValue != null) {
                throw new ParseException("Either an LDAP attribute name or an LDAP value must be specified, but not both", 0);
            }
            String ldapAttrType = null;
            if (map.containsKey("ldapType")) {
                try {
                    ldapAttrType = (String)map.get("ldapType");
                }
                catch (Exception e) {
                    throw new ParseException("Invalid LDAP attribute type", 0);
                }
            }
            if (ldapAttrType == null) {
                ldapAttrType = "string";
            }
            if (!ldapAttrType.equals("string") && !ldapAttrType.equals("time")) {
                throw new ParseException("Invalid attribute LDAP type, must be \"string\" or \"time\"", 0);
            }
            String jsonType = null;
            if (map.containsKey("jsonType")) {
                try {
                    jsonType = (String)map.get("jsonType");
                }
                catch (Exception e) {
                    throw new ParseException("Invalid JSON value type", 0);
                }
            }
            if (jsonType == null) {
                jsonType = "string";
            }
            if (!(jsonType.equals("string") || jsonType.equals("string-array") || jsonType.equals("int") || jsonType.equals("long") || jsonType.equals("boolean"))) {
                throw new ParseException("Invalid JSON value type, must be \"string\", \"string-array\", \"int\", \"long\" or \"boolean\"", 0);
            }
            boolean langTagged = false;
            if (map.containsKey("langTag")) {
                try {
                    langTagged = (Boolean)map.get("langTag");
                }
                catch (Exception e) {
                    throw new ParseException("Invalid language tag option, must be boolean true or false", 0);
                }
            }
            Pattern reMatch = null;
            if (map.containsKey("reMatch")) {
                try {
                    reMatch = Pattern.compile((String)map.get("reMatch"));
                }
                catch (Exception e) {
                    throw new ParseException("Invalid regular expression matching pattern for the LDAP value", 0);
                }
                Matcher m = reMatch.matcher("test");
                if (m.groupCount() != 1) {
                    throw new ParseException("The regular expression matching pattern for the LDAP value must contain one capturing group", 0);
                }
            }
            boolean split = false;
            if (map.containsKey("split")) {
                try {
                    split = (Boolean)map.get("split");
                }
                catch (Exception e) {
                    throw new ParseException("Invalid split setting, must be true or false", 0);
                }
            }
            return new Directive(ldapAttrName, ldapValue, ldapAttrType, jsonType, langTagged, reMatch, split);
        }
    }

    private static final class Key {
        private final String value;
        private final String[] parts;

        public Key(String value) {
            if (value == null) {
                throw new IllegalArgumentException("The JSON object member key must not be null");
            }
            this.value = value;
            this.parts = value.split("\\.");
            if (this.parts.length > 2) {
                throw new IllegalArgumentException("Too many dots in JSON object member key");
            }
        }

        public String value() {
            return this.value;
        }

        public boolean isNested() {
            return this.parts.length > 1;
        }

        public String[] parts() {
            return this.parts;
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof Key && this.toString().equals(other.toString());
        }
    }
}

