/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.id;

import com.nimbusds.common.id.BaseIdentifier;
import com.nimbusds.common.id.Username;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import java.text.ParseException;

public final class AuthzId
extends BaseIdentifier {
    public static final AuthzId ANONYMOUS = new AuthzId(DN.NULL_DN);
    private DN dn;
    private Username username;
    private IdentityType identityType;

    public static AuthzId parse(String value) throws ParseException {
        if (value == null || value.trim().isEmpty()) {
            return ANONYMOUS;
        }
        if (value.toLowerCase().startsWith("dn:")) {
            DN dn;
            try {
                dn = new DN(value.substring(3).trim());
            }
            catch (LDAPException e) {
                throw new ParseException("Bad authzId syntax: " + e.getMessage(), 3);
            }
            return new AuthzId(dn);
        }
        if (value.toLowerCase().startsWith("u:")) {
            return new AuthzId(new Username(value.substring(2)));
        }
        throw new ParseException("Bad authzId syntax: String must start with dn: or u:", 0);
    }

    private static String toAuthzIdString(DN dn) {
        if (dn == null) {
            throw new IllegalArgumentException("The authzId DN must not be null");
        }
        if (dn.equals((Object)DN.NULL_DN)) {
            return "dn:";
        }
        return "dn:" + dn.toNormalizedString();
    }

    private static String toAuthzIdString(Username username) {
        if (username == null) {
            throw new IllegalArgumentException("The authzId username must not be null");
        }
        if (username.toString().isEmpty()) {
            return "dn:";
        }
        return "u:" + username;
    }

    public AuthzId(DN dn) {
        super(AuthzId.toAuthzIdString(dn));
        this.identityType = IdentityType.DN;
        this.dn = dn;
        this.username = null;
    }

    public AuthzId(Username username) {
        super(AuthzId.toAuthzIdString(username));
        this.identityType = IdentityType.USERNAME;
        this.dn = null;
        this.username = username;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public DN getDN() {
        return this.dn;
    }

    public Username getUsername() {
        return this.username;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof AuthzId && this.toString().equals(object.toString());
    }

    public static enum IdentityType {
        DN,
        USERNAME;

    }
}

