/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.config;

import com.nimbusds.common.config.LDAPServerDetails;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LDAPServerConnectionPoolDetails
extends LDAPServerDetails {
    public final int connectionPoolSize;
    public static final int DEFAULT_CONNECTION_POOL_SIZE = 5;
    public final int connectionPoolMaxWaitTime;
    public static final int DEFAULT_CONNECTION_POOL_MAX_WAIT_TIME = 500;
    public final long connectionMaxAge;
    public static final int DEFAULT_CONNECTION_MAX_AGE = 0;

    public LDAPServerConnectionPoolDetails(String prefix, Properties props) throws PropertyParseException {
        this(prefix, props, true);
    }

    public LDAPServerConnectionPoolDetails(String prefix, Properties props, boolean requireURL) throws PropertyParseException {
        super(prefix, props, requireURL);
        PropertyRetriever pr = new PropertyRetriever(props);
        this.connectionPoolSize = pr.getOptInt(prefix + "connectionPoolSize", 5);
        this.connectionPoolMaxWaitTime = pr.getOptInt(prefix + "connectionPoolMaxWaitTime", 500);
        this.connectionMaxAge = pr.getOptLong(prefix + "connectionMaxAge", 0L);
    }

    @Override
    public void log() {
        super.log();
        if (this.url == null) {
            return;
        }
        Logger log = Logger.getLogger((String)"MAIN");
        log.info((Object)("LDAP server connection pool size: " + this.connectionPoolSize));
        log.info((Object)("LDAP server connection pool max wait time: " + this.connectionPoolMaxWaitTime + "ms"));
        log.info((Object)("LDAP server connection pool max age: " + this.connectionMaxAge + "ms"));
    }
}

