/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.nimbusds.common.config.CustomKeyStoreConfiguration;
import com.nimbusds.common.config.CustomTrustStoreConfiguration;
import com.nimbusds.common.config.DirectoryUser;
import com.nimbusds.common.config.LDAPServerConnectionPoolDetails;
import com.nimbusds.common.ldap.LDAPConnectionFactory;
import com.nimbusds.common.ldap.LDAPConnectionSecurity;
import com.nimbusds.common.ldap.LDAPServerSetFactory;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.StartTLSPostConnectProcessor;
import com.unboundid.util.ssl.SSLUtil;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class LDAPConnectionPoolFactory {
    private final LDAPServerConnectionPoolDetails ldapServer;
    private final CustomTrustStoreConfiguration customTrustStore;
    private final CustomKeyStoreConfiguration customKeyStore;
    private final DirectoryUser dirUser;

    public LDAPConnectionPoolFactory(LDAPServerConnectionPoolDetails ldapServer, CustomTrustStoreConfiguration customTrustStore, CustomKeyStoreConfiguration customKeyStore, DirectoryUser dirUser) {
        if (ldapServer == null || ldapServer.url.length == 0) {
            throw new IllegalArgumentException("The LDAP server details must not be null");
        }
        this.ldapServer = ldapServer;
        if (customTrustStore == null) {
            throw new IllegalArgumentException("The custom trust store must not be null");
        }
        this.customTrustStore = customTrustStore;
        if (customKeyStore == null) {
            throw new IllegalArgumentException("The custom key store must not be null");
        }
        this.customKeyStore = customKeyStore;
        this.dirUser = dirUser;
    }

    public LDAPConnectionPool createLDAPConnectionPool() throws KeyStoreException, GeneralSecurityException, LDAPException {
        SSLUtil sslUtil;
        SSLSocketFactory socketFactory = null;
        StartTLSPostConnectProcessor postProc = null;
        if (this.ldapServer.security.equals((Object)LDAPConnectionSecurity.SSL)) {
            sslUtil = LDAPConnectionFactory.initSecureConnectionContext(this.customTrustStore, this.customKeyStore, this.ldapServer.trustSelfSignedCerts);
            socketFactory = sslUtil.createSSLSocketFactory();
        } else if (this.ldapServer.security.equals((Object)LDAPConnectionSecurity.STARTTLS)) {
            sslUtil = LDAPConnectionFactory.initSecureConnectionContext(this.customTrustStore, this.customKeyStore, this.ldapServer.trustSelfSignedCerts);
            SSLContext sslContext = sslUtil.createSSLContext();
            postProc = new StartTLSPostConnectProcessor(sslContext);
        }
        LDAPConnectionOptions opts = new LDAPConnectionOptions();
        opts.setConnectTimeoutMillis(this.ldapServer.connectTimeout);
        ServerSet serverSet = LDAPServerSetFactory.create(this.ldapServer.url, this.ldapServer.selectionAlgorithm, socketFactory, opts);
        SimpleBindRequest bindRequest = null;
        if (this.dirUser != null) {
            bindRequest = new SimpleBindRequest(this.dirUser.dn, this.dirUser.password);
        }
        boolean numInitialConnections = false;
        LDAPConnectionPool pool = new LDAPConnectionPool(serverSet, (BindRequest)bindRequest, 0, this.ldapServer.connectionPoolSize, (PostConnectProcessor)postProc);
        pool.setCreateIfNecessary(true);
        pool.setMaxWaitTimeMillis((long)this.ldapServer.connectionPoolMaxWaitTime);
        pool.setMaxConnectionAgeMillis(this.ldapServer.connectionMaxAge);
        return pool;
    }
}

