/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.config;

import com.nimbusds.common.config.LoggableConfiguration;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

public class WebServiceDetails
implements LoggableConfiguration {
    public final URL url;
    public final boolean trustSelfSignedCerts;
    public static final boolean DEFAULT_SELF_SIGNED_CERT_TRUST = false;
    public final int connectTimeout;
    public static final int DEFAULT_CONNECT_TIMEOUT = 0;
    public final int readTimeout;
    public static final int DEFAULT_READ_TIMEOUT = 0;
    public final String apiKey;

    public WebServiceDetails(String prefix, Properties props) throws PropertyParseException {
        PropertyRetriever pr = new PropertyRetriever(props);
        this.url = pr.getURL(prefix + "url");
        if (!this.url.getProtocol().equalsIgnoreCase("http") && !this.url.getProtocol().equalsIgnoreCase("https")) {
            throw new PropertyParseException("URL protocol must be either HTTP or HTTPS", prefix + "url", this.url.toString());
        }
        this.trustSelfSignedCerts = pr.getOptBoolean(prefix + "trustSelfSignedCerts", false);
        this.connectTimeout = pr.getOptInt(prefix + "connectTimeout", 0);
        if (this.connectTimeout < 0) {
            throw new PropertyParseException("The connect timeout value must be zero or positive", prefix + "connectTimeout");
        }
        this.readTimeout = pr.getOptInt(prefix + "readTimeout", 0);
        if (this.readTimeout < 0) {
            throw new PropertyParseException("The read timeout value must be zero or positive", prefix + "readTimeout");
        }
        this.apiKey = pr.getOptString(prefix + "apiKey", null);
    }

    @Override
    public void log() {
        Logger log = Logger.getLogger((String)"MAIN");
        log.info((Object)("Web service URL: " + this.url));
        if (this.url.getProtocol().equalsIgnoreCase("http")) {
            log.warn((Object)"Web service connection is not protected (plain HTTP), consider using SSL (HTTPS)");
        }
        if (this.url.getProtocol().equalsIgnoreCase("https")) {
            log.info((Object)("Self-signed web service certificates are trusted: " + this.trustSelfSignedCerts));
        }
        if (this.connectTimeout > 0) {
            log.info((Object)("Web service HTTP connect timeout: " + this.connectTimeout + "us"));
        } else {
            log.info((Object)"Web service HTTP connect timeout: disabled");
        }
        if (this.readTimeout > 0) {
            log.info((Object)("Web service HTTP read timeout: " + this.readTimeout + "us"));
        } else {
            log.info((Object)"Web service HTTP read timeout: disabled");
        }
        if (this.apiKey != null) {
            log.info((Object)"Web service API key: provided");
        } else {
            log.info((Object)"Web service API key: not provided");
        }
    }
}

