/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;

public class InfinispanLauncher
implements ServletContextListener {
    public static final String INFINISPAN_CONFIG_FILENAME = "infinispan.configurationFile";
    public static final String INFINISPAN_CTX_ATTRIBUTE_NAME = "org.infinispan.manager.EmbeddedCacheManager";
    private EmbeddedCacheManager cacheManager;

    public void contextInitialized(ServletContextEvent sce) {
        Logger log = LogManager.getLogger((String)"MAIN");
        ServletContext servletContext = sce.getServletContext();
        String configFile = servletContext.getInitParameter(INFINISPAN_CONFIG_FILENAME);
        if (configFile == null || configFile.trim().isEmpty()) {
            String msg = "Couldn't load Infinispan configuration: Missing servlet context parameter \"infinispan.configurationFile\"";
            log.error(msg);
            throw new RuntimeException(msg);
        }
        InputStream is = servletContext.getResourceAsStream(configFile);
        if (is == null) {
            String msg = "Couldn't load Infinispan configuration file: " + configFile;
            log.error(msg);
            throw new RuntimeException(msg);
        }
        try {
            this.cacheManager = new DefaultCacheManager(is);
        }
        catch (Exception e) {
            String msg = "Couldn't start Infinispan cache manager: " + e.getMessage();
            log.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        servletContext.setAttribute(INFINISPAN_CTX_ATTRIBUTE_NAME, (Object)this.cacheManager);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.cacheManager == null) {
            return;
        }
        this.cacheManager.stop();
    }
}

