/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.Logger;

public class ResourceRetriever {
    public static InputStream getStream(ServletContext servletCtx, String paramName, Logger log) throws Exception {
        String file = servletCtx.getInitParameter(paramName);
        if (file == null || file.trim().isEmpty()) {
            String msg = "Missing " + paramName + " context parameter in web.xml";
            log.error(msg);
            throw new Exception(msg);
        }
        InputStream is = servletCtx.getResourceAsStream(file);
        if (is == null) {
            String msg = "Missing file or invalid path: " + file;
            log.error(msg);
            throw new Exception(msg);
        }
        return is;
    }

    public static String getString(ServletContext servletCtx, String paramName, Logger log) throws Exception {
        InputStream is = ResourceRetriever.getStream(servletCtx, paramName, log);
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            reader.close();
        }
        catch (IOException e) {
            String msg = "Couldn't read file: " + e.getMessage();
            log.error(msg);
            throw new Exception(msg, e);
        }
        return sb.toString();
    }

    public static Properties getProperties(ServletContext servletCtx, String paramName, Logger log) throws Exception {
        String file = servletCtx.getInitParameter(paramName);
        InputStream is = ResourceRetriever.getStream(servletCtx, paramName, log);
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            String msg = "Couldn't read properties file: " + e.getMessage();
            log.error(msg);
            throw new Exception(msg, e);
        }
        catch (IllegalArgumentException e) {
            String msg = "Bad properties file: " + e.getMessage();
            log.error(msg);
            throw new Exception(msg, e);
        }
        log.info("Loaded properties file {}", new Object[]{file});
        return props;
    }

    private ResourceRetriever() {
    }
}

