/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class URLUtility {
    public static final String CHARSET = "utf-8";

    public static URL getBaseURL(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String serializeParameters(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            try {
                String encodedKey = URLEncoder.encode(entry.getKey(), CHARSET);
                String encodedValue = URLEncoder.encode(entry.getValue(), CHARSET);
                if (sb.length() > 0) {
                    sb.append('&');
                }
                sb.append(encodedKey);
                sb.append('=');
                sb.append(encodedValue);
            }
            catch (UnsupportedEncodingException e) {}
        }
        return sb.toString();
    }

    public static Map<String, String> parseParameters(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (query == null) {
            return params;
        }
        try {
            for (String param : query.split("&")) {
                String[] pair = param.split("=");
                String key = URLDecoder.decode(pair[0], CHARSET);
                if (params.containsKey(key)) continue;
                String value = "";
                if (pair.length > 1) {
                    value = URLDecoder.decode(pair[1], CHARSET);
                }
                params.put(key, value);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return params;
    }

    private URLUtility() {
    }
}

