/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.oauth2;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class BasicAccessTokenValidator {
    private static final String MISSING_BEARER_TOKEN;
    private static final String INVALID_BEARER_TOKEN;
    private static final String WEB_API_DISABLED;
    private final BearerAccessToken accessToken;

    public BasicAccessTokenValidator(BearerAccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public BearerAccessToken getAccessToken() {
        return this.accessToken;
    }

    public void validateBearerAccessToken(String authzHeader) throws WebApplicationException {
        BearerAccessToken receivedToken;
        if (StringUtils.isBlank((CharSequence)authzHeader)) {
            throw new WebApplicationException(Response.status((int)BearerTokenError.MISSING_TOKEN.getHTTPStatusCode()).header("WWW-Authenticate", (Object)BearerTokenError.MISSING_TOKEN.toWWWAuthenticateHeader()).entity((Object)MISSING_BEARER_TOKEN).type("application/json").build());
        }
        try {
            receivedToken = BearerAccessToken.parse((String)authzHeader);
        }
        catch (ParseException e) {
            throw new WebApplicationException(Response.status((int)BearerTokenError.MISSING_TOKEN.getHTTPStatusCode()).header("WWW-Authenticate", (Object)BearerTokenError.MISSING_TOKEN.toWWWAuthenticateHeader()).entity((Object)MISSING_BEARER_TOKEN).type("application/json").build());
        }
        if (this.accessToken == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)WEB_API_DISABLED).type("application/json").build());
        }
        if (!receivedToken.equals((Object)this.accessToken)) {
            throw new WebApplicationException(Response.status((int)BearerTokenError.INVALID_TOKEN.getHTTPStatusCode()).header("WWW-Authenticate", (Object)BearerTokenError.INVALID_TOKEN.toWWWAuthenticateHeader()).entity((Object)INVALID_BEARER_TOKEN).type("application/json").build());
        }
    }

    static {
        JSONObject o = new JSONObject();
        o.put((Object)"error", (Object)"missing_token");
        o.put((Object)"error_description", (Object)"Unauthorized: Missing Bearer access token");
        MISSING_BEARER_TOKEN = o.toJSONString();
        o = new JSONObject();
        o.put((Object)"error", (Object)BearerTokenError.INVALID_TOKEN.getCode());
        o.put((Object)"error_description", (Object)"Unauthorized: Invalid Bearer access token");
        INVALID_BEARER_TOKEN = o.toJSONString();
        o = new JSONObject();
        o.put((Object)"error", (Object)"web_api_disabled");
        o.put((Object)"error_description", (Object)"Forbidden: Web API disabled");
        WEB_API_DISABLED = o.toJSONString();
    }
}

