package com.nimbusds.common.servlet;


import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import com.nimbusds.common.metrics.MetricsRegistries;


/**
 * Exports the shared {@link com.nimbusds.common.metrics.MetricsRegistries}
 * into the servlet context.
 */
public class MetricsLauncher implements ServletContextListener {


	@Override
	public void contextInitialized(ServletContextEvent sce) {

		sce.getServletContext().setAttribute(
			"com.codahale.metrics.servlets.MetricsServlet.registry",
			MetricsRegistries.getMetricRegistry());

		sce.getServletContext().setAttribute("com.codahale.metrics.servlets.HealthCheckServlet.registry",
			MetricsRegistries.getHealthCheckRegistry());
	}


	@Override
	public void contextDestroyed(ServletContextEvent sce) {
		// Nothing do to
	}
}
