/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.monitor;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import java.util.Map;

public class MonitorRegistries {
    private static MetricRegistry metricRegistry;
    private static HealthCheckRegistry healthCheckRegistry;

    public static MetricRegistry getMetricRegistry() {
        if (metricRegistry != null) {
            return metricRegistry;
        }
        metricRegistry = new MetricRegistry();
        return metricRegistry;
    }

    public static HealthCheckRegistry getHealthCheckRegistry() {
        if (healthCheckRegistry != null) {
            return healthCheckRegistry;
        }
        healthCheckRegistry = new HealthCheckRegistry();
        return healthCheckRegistry;
    }

    public static void register(MetricSet metricSet) {
        if (metricSet == null) {
            return;
        }
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            MonitorRegistries.register((String)entry.getKey(), (Metric)entry.getValue());
        }
    }

    public static void register(String name, Metric metric) {
        if (name == null || metric == null) {
            return;
        }
        if (MonitorRegistries.getMetricRegistry().getNames().contains(name)) {
            return;
        }
        MonitorRegistries.getMetricRegistry().register(name, metric);
    }

    public static void register(String name, HealthCheck check) {
        if (name == null || check == null) {
            return;
        }
        if (MonitorRegistries.getHealthCheckRegistry().getNames().contains(name)) {
            return;
        }
        MonitorRegistries.getHealthCheckRegistry().register(name, check);
    }

    private MonitorRegistries() {
    }
}

