/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.nimbusds.common.monitor.MonitorRegistries;
import com.nimbusds.common.servlet.ResourceRetriever;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorLauncher
implements ServletContextListener {
    public static final String CONFIG_CTX_PARAMETER_NAME = "monitor.configurationFile";
    public static final String ENABLE_JMX_PROPERTY_NAME = "monitor.enableJMX";
    protected JmxReporter jmxReporter;

    public void contextInitialized(ServletContextEvent sce) {
        boolean enableJMX;
        Properties props;
        sce.getServletContext().setAttribute("com.codahale.metrics.servlets.MetricsServlet.registry", (Object)MonitorRegistries.getMetricRegistry());
        sce.getServletContext().setAttribute("com.codahale.metrics.servlets.HealthCheckServlet.registry", (Object)MonitorRegistries.getHealthCheckRegistry());
        Logger log = LogManager.getLogger((String)"MAIN");
        try {
            props = ResourceRetriever.getProperties(sce.getServletContext(), CONFIG_CTX_PARAMETER_NAME, log);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        if (System.getProperties().containsKey(ENABLE_JMX_PROPERTY_NAME)) {
            props.setProperty(ENABLE_JMX_PROPERTY_NAME, System.getProperty(ENABLE_JMX_PROPERTY_NAME));
        }
        PropertyRetriever pr = new PropertyRetriever(props);
        try {
            enableJMX = pr.getBoolean(ENABLE_JMX_PROPERTY_NAME);
        }
        catch (PropertyParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        if (enableJMX) {
            this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)MonitorRegistries.getMetricRegistry()).build();
            this.jmxReporter.start();
            log.info("Started monitor JMX reporter");
        } else {
            log.info("Metrics JMX reported disabled");
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.jmxReporter != null) {
            this.jmxReporter.stop();
        }
    }
}

